package com.atlassian.crowd.embedded.spi;

import com.atlassian.crowd.exception.DirectoryNotFoundException;

import javax.annotation.Nullable;

public interface DirectorySynchronisationTokenDao {

    /**
     * Returns the last stored synchronisation token for the directory
     * @param directoryId the id of the directory
     * @return the last stored synchronisation token
     */
    @Nullable
    String getLastSynchronisationTokenForDirectory(long directoryId);

    /**
     * Store a new synchronisation token for the given directory. This will overwrite the old token.
     * @param directoryId the id of the directory
     * @param synchronisationToken the new token to store
     */
    void storeSynchronisationTokenForDirectory(long directoryId, String synchronisationToken) throws DirectoryNotFoundException;

    /**
     * Clears the synchronisation token for the given directory
     *
     * @param directoryId directory id
     */
    void clearSynchronisationTokenForDirectory(long directoryId);

}
