/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IdentifierMap<V>
extends HashMap<String, V> {
    public IdentifierMap() {
    }

    public IdentifierMap(int expectedSize) {
        super(expectedSize);
    }

    public IdentifierMap(Map<String, V> map) {
        this(map.size());
        this.putAll(map);
    }

    String toLowerCase(Object key) {
        return key != null ? IdentifierUtils.toLowerCase((String)key) : null;
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
        super.replaceAll(function);
    }

    @Override
    public V get(Object key) {
        return super.get(this.toLowerCase(key));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return super.getOrDefault(this.toLowerCase(key), defaultValue);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        super.putAll(m.entrySet().stream().collect(Collectors.toMap(e -> this.toLowerCase(e.getKey()), Map.Entry::getValue)));
    }

    @Override
    public V put(String key, V value) {
        return super.put(this.toLowerCase(key), value);
    }

    @Override
    public V remove(Object key) {
        return super.remove(this.toLowerCase(key));
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return super.putIfAbsent(this.toLowerCase(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(this.toLowerCase(key), value);
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        return super.replace(this.toLowerCase(key), oldValue, newValue);
    }

    @Override
    public V replace(String key, V value) {
        return super.replace(this.toLowerCase(key), value);
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return super.computeIfAbsent(this.toLowerCase(key), mappingFunction);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.toLowerCase(key));
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.computeIfPresent(this.toLowerCase(key), remappingFunction);
    }

    @Override
    public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.compute(this.toLowerCase(key), remappingFunction);
    }

    @Override
    public V merge(String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return super.merge(this.toLowerCase(key), value, remappingFunction);
    }

    public static <T> IdentifierMap<T> index(Collection<? extends T> items, Function<T, String> nameGetter) {
        IdentifierMap result = new IdentifierMap(items.size());
        items.forEach((? super T item) -> result.put((String)nameGetter.apply(item), item));
        return result;
    }
}

