package com.atlassian.crowd.validator;

/**
 * Represents a single error containing the field name and corresponding error message
 *
 * @since 3.2.0
 */
public interface ValidationError {

    /**
     * Returns name of the field for which this error was raised
     *
     * @return Field name
     */
    String getFieldName();

    /**
     * Returns the actual error message
     *
     * @return Error message
     */
    String getErrorMessage();

}
