package com.atlassian.crowd.embedded.api;

/**
 * Encryptor can be used to encrypt / decrypt passwords.
 * Password encrypted with {@link #encrypt} can later be decrypted with {@link #decrypt}.
 */
public interface Encryptor {

    /**
     * Encrypt plaintext password, and return encrypted value which can later be used in decrypt method to get plaintext password.
     *
     * @return encrypted password.
     * @throws com.atlassian.crowd.exception.crypto.MissingKeyException when encryption key has not been found in the file system or the default key is not set
     */
    String encrypt(String password);

    /**
     * Decrypt encrypted password, and return its original value.
     * <p>
     * In case of any error during decryption (such as missing decryption key) return <code>encryptedPassword</code>.
     *
     * @return decrypted password or unchanged <code>encryptedPassword</code> in case of any error
     */
    String decrypt(String encryptedPassword);

    /**
     * Generate new encryption key, which  should be used to encrypt password in following calls to {@link Encryptor#encrypt}.
     *
     * @return true if generation was successful, or false when encryption key migration is not supported
     */
    default boolean changeEncryptionKey() {
        return false;
    }
}
