/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PasswordCredential
implements Serializable {
    public static final PasswordCredential NONE = PasswordCredential.encrypted("X");
    private boolean encryptedCredential = false;
    protected String credential;

    public static PasswordCredential encrypted(String encryptedCredential) {
        return new PasswordCredential(encryptedCredential, true);
    }

    public static PasswordCredential unencrypted(String unencryptedCredential) {
        return new PasswordCredential(unencryptedCredential, false);
    }

    public PasswordCredential() {
        this.encryptedCredential = true;
    }

    public PasswordCredential(PasswordCredential passwordCredential) {
        if (passwordCredential != null) {
            this.setCredential(passwordCredential.getCredential());
            this.setEncryptedCredential(passwordCredential.isEncryptedCredential());
        }
    }

    public PasswordCredential(String unencryptedCredential) {
        this.encryptedCredential = false;
        this.credential = unencryptedCredential;
    }

    public PasswordCredential(String credential, boolean encryptedCredential) {
        this.credential = credential;
        this.encryptedCredential = encryptedCredential;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public boolean isEncryptedCredential() {
        return this.encryptedCredential;
    }

    public void setEncryptedCredential(boolean encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordCredential that = (PasswordCredential)o;
        return this.credential != null ? this.credential.equals(that.credential) : that.credential == null;
    }

    public int hashCode() {
        return this.credential != null ? this.credential.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("credential", (Object)this.credential).append("encryptedCredential", this.encryptedCredential).toString();
    }
}

