/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

public class ExecuteCommand
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog((Class)ExecuteCommand.class);

    public boolean execute(ActionContext actionCtx) throws Exception {
        Command command;
        if (this.shouldProcess(actionCtx) && (command = this.getCommand(actionCtx)) != null) {
            return command.execute(actionCtx);
        }
        return false;
    }

    protected boolean shouldProcess(ActionContext context) {
        Boolean valid = context.getFormValid();
        return valid != null && valid != false;
    }

    protected Command getCommand(ActionContext context) {
        ActionConfig actionConfig = context.getActionConfig();
        String commandName = actionConfig.getCommand();
        if (commandName == null) {
            return null;
        }
        String catalogName = actionConfig.getCatalog();
        return this.getCommand(commandName, catalogName);
    }

    protected Command getCommand(String commandName, String catalogName) {
        Catalog catalog;
        if (commandName == null) {
            return null;
        }
        if (catalogName != null) {
            catalog = CatalogFactory.getInstance().getCatalog(catalogName);
            if (catalog == null) {
                LOG.warn((Object)("When looking up " + commandName + "," + " no catalog found under " + catalogName));
                return null;
            }
        } else {
            catalogName = "the default catalog";
            catalog = CatalogFactory.getInstance().getCatalog();
            if (catalog == null) {
                LOG.warn((Object)("When looking up " + commandName + "," + " no default catalog found."));
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("looking up command " + commandName + " in " + catalogName));
        }
        return catalog.getCommand(commandName);
    }
}

