/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.crowd.embedded.admin.rest.entities.ApplicationEntity;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.sal.api.user.UserManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/application")
@Produces(value={"application/xml", "application/json"})
public class ApplicationResource {
    @Context
    private UriInfo uriInfo;
    private final CrowdDirectoryService crowdDirectoryService;
    private final UserManager userManager;

    public ApplicationResource(CrowdDirectoryService crowdDirectoryService, UserManager userManager) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.userManager = userManager;
    }

    @GET
    public ApplicationEntity get() {
        boolean membershipAggregationEnabled = this.crowdDirectoryService.isMembershipAggregationEnabled();
        ApplicationEntity entity = new ApplicationEntity();
        entity.setMembershipAggregationEnabled(membershipAggregationEnabled);
        return entity;
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    public Response update(ApplicationEntity entity) {
        this.checkSysAdmin();
        Boolean membershipAggregationEnabled = entity.isMembershipAggregationEnabled();
        if (membershipAggregationEnabled != null) {
            this.crowdDirectoryService.setMembershipAggregationEnabled(membershipAggregationEnabled.booleanValue());
        }
        return Response.noContent().build();
    }

    private void checkSysAdmin() {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (remoteUsername == null || !this.userManager.isSystemAdmin(remoteUsername)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }
}

