/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.embedded.admin.ldap.SharedLdapDirectoryConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class SharedLdapDirectoryConfigurationValidator<T extends SharedLdapDirectoryConfiguration>
implements Validator {
    public final void validate(Object target, Errors errors) {
        SharedLdapDirectoryConfiguration configuration = (SharedLdapDirectoryConfiguration)target;
        this.validateConfiguration(configuration, errors);
        if (!errors.hasFieldErrors("hostname") && !errors.hasFieldErrors("port")) {
            try {
                URI uri = new URI(configuration.getLdapUrl());
                if (uri.getHost() == null) {
                    errors.rejectValue("hostname", "invalid");
                }
            }
            catch (URISyntaxException e) {
                errors.rejectValue("hostname", "invalid");
            }
        }
    }

    protected abstract void validateConfiguration(T var1, Errors var2);
}

