/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SharedLdapDirectoryConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LdapDirectoryConfiguration.class);
    private String hostname;
    private int port = 389;
    private boolean useSSL;

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getLdapUrl() {
        return (this.useSSL ? "ldaps" : "ldap") + "://" + this.hostname + ":" + this.port;
    }

    public void setLdapUrl(String url) {
        if (url == null || url.length() == 0 || !url.contains("://")) {
            return;
        }
        this.useSSL = url.startsWith("ldaps");
        try {
            URI uri = new URI(url);
            this.hostname = uri.getHost();
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
        }
        catch (URISyntaxException e) {
            log.warn("Got an invalid ldap url: {}", (Object)url, (Object)e);
        }
    }
}

