/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.crowd.embedded.admin.rest.entities.DirectoryEntity;
import com.atlassian.crowd.embedded.admin.rest.entities.DirectoryList;
import com.atlassian.crowd.embedded.admin.rest.entities.DirectorySynchronisationInformationEntity;
import com.atlassian.crowd.embedded.admin.util.SimpleMessage;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/")
public class DirectoryResource {
    @Context
    private UriInfo uriInfo;
    private final CrowdDirectoryService crowdDirectoryService;
    private final I18nResolver i18nResolver;

    public DirectoryResource(CrowdDirectoryService crowdDirectoryService, I18nResolver i18nResolver) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/directory")
    public Response get() {
        List directories = this.crowdDirectoryService.findAllDirectories();
        DirectoryList list = new DirectoryList();
        for (Directory directory : directories) {
            list.getDirectories().add(this.buildDirectoryEntity(directory));
        }
        return Response.ok((Object)list).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/directory/{id}")
    public Response getDirectory(@PathParam(value="id") Long id) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(id.longValue());
        if (directory != null) {
            return Response.ok((Object)this.buildDirectoryEntity(directory)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private DirectoryEntity buildDirectoryEntity(Directory directory) {
        DirectoryEntity entity = new DirectoryEntity();
        entity.setName(directory.getName());
        entity.getLinks().add(Link.self((URI)this.getDirectoryUriBuilder().build(new Object[]{directory.getId()})));
        DirectorySynchronisationInformation syncInformation = this.crowdDirectoryService.getDirectorySynchronisationInformation(directory.getId().longValue());
        if (syncInformation != null) {
            DirectorySynchronisationInformationEntity syncEntity = new DirectorySynchronisationInformationEntity();
            if (syncInformation.getLastRound() != null) {
                syncEntity.setLastSyncDurationInSeconds(syncInformation.getLastRound().getDurationMs() / 1000L);
                syncEntity.setLastSyncStartTime(DateFormat.getDateTimeInstance(3, 3).format(syncInformation.getLastRound().getStartTime()));
            }
            if (syncInformation.getActiveRound() != null) {
                syncEntity.setCurrentSyncStartTime(syncInformation.getActiveRound().getStartTime());
                syncEntity.setCurrentDurationInSeconds((System.currentTimeMillis() - syncInformation.getActiveRound().getStartTime()) / 1000L);
            } else {
                syncEntity.setCurrentDurationInSeconds(0L);
            }
            Message syncStatusMessage = this.getSyncStatusMessage(syncInformation);
            if (syncStatusMessage != null) {
                syncEntity.setSyncStatus(this.i18nResolver.getText(syncStatusMessage));
            }
            entity.setSync(syncEntity);
        }
        return entity;
    }

    protected UriBuilder getDirectoryUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("directory").path("{id}");
    }

    private Message getSyncStatusMessage(DirectorySynchronisationInformation syncInfo) {
        DirectorySynchronisationRoundInformation syncRound;
        DirectorySynchronisationRoundInformation directorySynchronisationRoundInformation = syncRound = syncInfo.isSynchronising() ? syncInfo.getActiveRound() : syncInfo.getLastRound();
        if (syncRound == null) {
            return null;
        }
        String statusKey = syncRound.getStatusKey();
        if (statusKey == null) {
            return null;
        }
        Serializable[] params = syncRound.getStatusParameters().toArray(new Serializable[0]);
        return SimpleMessage.instance((String)("embedded.crowd." + statusKey), (Serializable[])params);
    }
}

