/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.xwork.interceptors;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.interceptor.PreResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

class TransactionalInvocation {
    private static final Logger log = LoggerFactory.getLogger(TransactionalInvocation.class);
    private final TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(0);
    private final PlatformTransactionManager transactionManager;
    private TransactionStatus transactionStatus;

    public TransactionalInvocation(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invokeInTransaction(final ActionInvocation invocation) throws Exception {
        log.debug("Creating transaction for action invocation: {}", (Object)this.getDetails(invocation));
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)this.transactionAttribute);
        invocation.addPreResultListener(new PreResultListener(){

            public void beforeResult(ActionInvocation actionInvocation, String s) {
                TransactionalInvocation.this.commitOrRollbackTransaction(invocation, false);
                log.debug("Creating transaction for action result: {}", (Object)TransactionalInvocation.this.getDetails(invocation));
                TransactionalInvocation.this.transactionStatus = TransactionalInvocation.this.transactionManager.getTransaction((TransactionDefinition)TransactionalInvocation.this.transactionAttribute);
            }
        });
        boolean swallowCommitErrors = true;
        try {
            String result = this.invokeAndHandleExceptions(invocation);
            swallowCommitErrors = false;
            String string = result;
            return string;
        }
        finally {
            this.commitOrRollbackTransaction(invocation, swallowCommitErrors);
        }
    }

    private String invokeAndHandleExceptions(ActionInvocation invocation) throws Exception {
        try {
            return invocation.invoke();
        }
        catch (Exception ex) {
            this.handleInvocationException(invocation, this.transactionAttribute, this.transactionStatus, ex);
            throw ex;
        }
    }

    private void commitOrRollbackTransaction(ActionInvocation actionInvocation, boolean swallowCommitErrors) {
        try {
            if (this.transactionStatus.isCompleted()) {
                log.error("Action {} is already completed and can not be committed again.", (Object)this.getDetails(actionInvocation));
            } else if (this.transactionStatus.isRollbackOnly()) {
                log.debug("Transaction status for action {} set to rollback only. Invoking rollback()", (Object)this.getDetails(actionInvocation));
                this.transactionManager.rollback(this.transactionStatus);
            } else {
                log.debug("Committing transaction for action {}", (Object)this.getDetails(actionInvocation));
                this.transactionManager.commit(this.transactionStatus);
            }
        }
        catch (RuntimeException e) {
            if (swallowCommitErrors) {
                log.error("Commit/Rollback exception occurred but was swallowed", (Throwable)e);
            }
            throw e;
        }
    }

    private void handleInvocationException(ActionInvocation invocation, TransactionAttribute txAtt, TransactionStatus status, Throwable ex) {
        if (status == null) {
            return;
        }
        if (txAtt.rollbackOn(ex)) {
            log.info("Invoking rollback for transaction on action '{}' due to throwable: {}", new Object[]{this.getDetails(invocation), ex, ex});
            status.setRollbackOnly();
        } else {
            log.debug("Action {} threw exception {} but did not trigger a rollback.", (Object)this.getDetails(invocation), (Object)ex);
        }
    }

    private String getDetails(ActionInvocation invocation) {
        ActionProxy proxy = invocation.getProxy();
        String methodName = proxy.getConfig().getMethodName();
        if (methodName == null) {
            methodName = "execute";
        }
        String actionClazz = TransactionalInvocation.getJustClassName(proxy.getConfig().getClassName());
        return proxy.getNamespace() + "/" + proxy.getActionName() + ".action (" + actionClazz + "." + methodName + "())";
    }

    private static String getJustClassName(String name) {
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos != -1) {
            return name.substring(lastDotPos + 1);
        }
        return name;
    }
}

