(function ($, root, adminApp) {
    var flag = require('aui/flag');

    root.routes = root.routes || {};

    AJS.I18n.keys = $.extend(AJS.I18n.keys, {
        "usermanagement.passwordpolicy.names.UNKNOWN": AJS.I18n.getText("usermanagement.passwordpolicy.names.UNKNOWN"),
        "usermanagement.passwordpolicy.names.WEAK": AJS.I18n.getText("usermanagement.passwordpolicy.names.WEAK"),
        "usermanagement.passwordpolicy.names.FAIR": AJS.I18n.getText("usermanagement.passwordpolicy.names.FAIR"),
        "usermanagement.passwordpolicy.names.GOOD": AJS.I18n.getText("usermanagement.passwordpolicy.names.GOOD"),
        "usermanagement.passwordpolicy.names.STRONG": AJS.I18n.getText("usermanagement.passwordpolicy.names.STRONG"),
        "usermanagement.passwordpolicy.names.VERY_STRONG": AJS.I18n.getText("usermanagement.passwordpolicy.names.VERY_STRONG")
    });

    root.routes.passwordpolicy = {
        list: function () {
            root.helpers.updateContent(usermanagement.passwordpolicy.optionsPrefetch());
            var rotationFormDialog = new root.routes.PasswordRotationDialog();
            root.helpers.ajax.getPasswordPolicy().done(function (policyArguments) {
                root.helpers.updateContent(usermanagement.passwordpolicy.options({
                    policyScore: AJS.I18n.getText('usermanagement.passwordpolicy.names.' + policyArguments.policyScore.name),
                    expiry: policyArguments.expiry,
                    lastReset: policyArguments.lastReset && root.helpers.formatDateTime(policyArguments.lastReset),
                    minimumPasswordRotation: policyArguments.minimumPasswordRotation
                }));

                $("#inline-dialog-password-score-policy").remove();
                var scoreFormDialog = AJS.InlineDialog(
                    "#inline-score-dialog",
                    "password-score-policy",
                    function(content, trigger, showPopup) {
                        content.html(usermanagement.passwordpolicy.scoreForm(policyArguments));
                        new root.UMForm('#password-policy-score-form', 'POST').on('done', function (data) {
                            policyArguments.policyScore = data.policyScore;

                            $("#inline-score-dialog").text(AJS.I18n.getText('usermanagement.passwordpolicy.names.' + data.policyScore.name));

                            root.helpers.triggerAnalytics("passwordpolicy.score.change", {
                                score: data.policyScore.ranking
                            });

                            flag({
                                type: "success",
                                close: "auto",
                                body: AJS.I18n.getText('usermanagement.passwordpolicy.minimum.success')
                            });

                            scoreFormDialog.hide();
                        });
                        showPopup();
                        return false;
                    }, {
                        cacheContent: false,
                        hideDelay: null
                    }
                );

                $("#inline-dialog-password-expiry-policy").remove();
                var expiryFormDialog = AJS.InlineDialog(
                    "#inline-expiry-dialog",
                    "password-expiry-policy",
                    function(content, trigger, showPopup) {
                        content.html(usermanagement.passwordpolicy.expiryForm(policyArguments));
                        new root.UMForm('#password-policy-expiry-form', 'POST', {
                            dataFormatter: function (data) {
                                return _.extend(_.clone(data), {
                                    daysTillExpiry: +data.daysTillExpiry
                                });
                            }
                        }).on('done', function (data) {
                            policyArguments.expiry = data.expiry;

                            $("#inline-expiry-dialog").text(AJS.I18n.getText('usermanagement.passwordpolicy.expiry.unit', policyArguments.expiry));

                            root.helpers.triggerAnalytics("passwordpolicy.expiry.change", {
                                days: data.expiry
                            });

                            flag({
                                type: "success",
                                close: "auto",
                                body: AJS.I18n.getText('usermanagement.passwordpolicy.expiry.success')
                            });

                            expiryFormDialog.hide();
                        }).addValidator(root.controllers.validators.NumberRangeValidator.create('daysTillExpiry', AJS.I18n.getText('usermanagement.passwordpolicy.invalidExpiry', 1, 999), 1, 999, '#expire-days'));
                        showPopup();
                        return false;
                    }, {
                        cacheContent: false,
                        hideDelay: null
                    }
                );
                rotationFormDialog.show(policyArguments);
            });

            return {
                events: _.extend(rotationFormDialog.getEvents(), {
                    "change #never-expire": function () {
                        var expiryField = $("#daysTillExpiry");
                        expiryField.prop("disabled", this.checked);
                        if (!root.controllers.validators.NumberRangeValidator.validateInt(expiryField.val(), 1, 999)) {
                            expiryField.val('');
                        }
                    },
                    "change #expire-days": function () {
                            $("#daysTillExpiry").prop("disabled", !this.checked);
                    },
                    "click #password-reset-button": function () {
                        var dialog = new root.UMModal({
                            height: 260,
                            template: usermanagement.passwordpolicy.resetConfirmationDialog(),
                            title:  AJS.I18n.getText('usermanagement.passwordpolicy.reset.prompt.title'),
                            submitButton: AJS.I18n.getText('usermanagement.passwordpolicy.reset.prompt.submitButton')
                        });

                        root.helpers.triggerAnalytics("passwordpolicy.reset.initial");

                        new root.UMForm('#password-reset-dialog', 'POST').on('done', function () {
                            dialog.remove();
                            root.helpers.triggerAnalytics("passwordpolicy.reset.confirm");
                            flag({
                                type: "success",
                                close: "auto",
                                body: AJS.I18n.getText('usermanagement.passwordpolicy.reset.success')
                            });
                            root.helpers.ajax.logoutUser();
                        });
                    }
                })
            };
        }
    }
}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));
