(function ($, root, adminApp) {
    var LEGACY_GAPPS_TYPE = 'UserProvisioningAPI';
    var flag = require('aui/flag');

    root.routes.googleapps = {
        list: function () {
            getGappsStatus().done(function (data) {
                renderGAppsStatus(data.gappsDomain, data.gappsType);
            });

            return {
                events: {
                    "click #enable-gapps-button": function () {
                        var enableDialog = new root.UMModal({
                            height: 260,
                            template: usermanagement.googleapps.connectDialog(),
                            title:  AJS.I18n.getText('usermanagement.googleapps.enable.confirm.title'),
                            submitButton: AJS.I18n.getText('usermanagement.googleapps.enable.confirm.button'),
                            onSubmit: function () {
                                // kick things off by POSTing to Agni
                                $.post(AGNI_URLS.startOAuthDance + '?' + $.param({ 'redirect_uri': window.location.href + "/add" }))
                                        .done(function (googleURL) {
                                            window.location = googleURL;
                                        })
                                        .fail(renderGAppsError)
                                        .always(function () {
                                            enableDialog.remove();
                                        });
                            }
                        });
                    },
                    "click #disable-gapps-button": function () {
                        var disableDialog = new root.UMModal({
                            height: 260,
                            template: AJS.I18n.getText('usermanagement.googleapps.disable.confirm.instructions'),
                            title:  AJS.I18n.getText('usermanagement.googleapps.disable.confirm.title'),
                            submitButton: AJS.I18n.getText('usermanagement.googleapps.disable.confirm.button'),
                            onSubmit: function () {
                                $.ajax(AGNI_URLS.gappsDomain, {
                                    type: 'DELETE'
                                }).done(function () {
                                    getGappsStatus.reset();
                                    adminApp.app.trigger('list',  { type: 'googleapps' });
                                }).fail(renderGAppsError)
                                 .always(function () {disableDialog.remove();});
                            }
                        });
                    }
                }
            };
        },

        /**
         * Displays an error or success message depending and sends the user back to the
         * GApps landing page.
         */
        add: function (params) {
            var error = params.error;
            if (error) {
                // display the right error for each Agni error code, falling back to a generic error if need be
                flag(_.extend({type: "error"}, Messages.fromAgniErrorCode(error.code, error.message)));
            } else {
                // an absence of errors can only mean success!
                flag(_.extend({type: "success", close: 'auto'}, Messages.success()));

            }

            // back to the GApps main page
            adminApp.app.navigate("list", { type: "googleapps" }, { replace: true });
        }
    };

    var Messages = (function () {
        /*
         * I18n.getText relies on regex-based transformations so some duplication is inevitable here. Would be fixed by
         * https://ecosystem.atlassian.net/browse/PLUGWEB-154
         */
        var knownErrors = {
            'auth_error': AJS.I18n.getText('usermanagement.users.google.callback.error.auth_error'),
            'code_not_provided': AJS.I18n.getText('usermanagement.users.google.callback.error.code_not_provided'),
            'get_token_failure': AJS.I18n.getText('usermanagement.users.google.callback.error.get_token_failure'),
            'status_check_failed':  function(errorMessage) {
                errorMessage = errorMessage || '';
                if (errorMessage.match('"domainCannotUseApis"')) {
                    return AJS.I18n.getText('usermanagement.users.google.callback.error.status_check_failed.domainCannotUseApis', '<a href="https://confluence.atlassian.com/x/dYLRKQ" target="_blank">', '</a>');
                }

                if (errorMessage.match('"forbidden"')) {
                    return AJS.I18n.getText('usermanagement.users.google.callback.error.status_check_failed.forbidden');
                }

                return AJS.I18n.getText('usermanagement.users.google.callback.error.status_check_failed');
            }
        };

        /**
         * Maps error codes+messages into errors that are meaningful to admins.
         *
         * @param {string} code the error code
         * @param {string} message the error message
         * @return {string} the error summary to display
         */
        function findSummary(code, message) {
            var summary = knownErrors[code];
            if (_.isFunction(summary)) {
                summary = summary(message);
            }

            if (_.isString(summary)) {
                return summary;
            }

            return AJS.I18n.getText('usermanagement.users.google.callback.error.generic');
        }

        return {
            /**
             * @return {{title: string, body: string}} a generic success message
             */
            success: function () {
                return {
                    title: AJS.I18n.getText('usermanagement.users.google.callback.success.title'),
                    body: usermanagement.googleapps.agniCallbackSuccess({
                        summary: AJS.I18n.getText('usermanagement.users.google.callback.success.generic')
                    })
                };
            },

            /**
             * Translates an Agni error code into a suitable error message to be displayed to users. The returned object
             * is suitable for passing straight to aui flag.
             *
             * @param {string} errorCode the Agni error code
             * @param {string} [errorMessage] an optional error message
             * @return {{title: string, body: string}} an error message
             */
            fromAgniErrorCode: function (errorCode, errorMessage) {
                return {
                    title: AJS.I18n.getText('usermanagement.users.google.callback.error.title'),
                    body: usermanagement.googleapps.agniCallbackError({
                        summaryHtml: findSummary(errorCode, errorMessage),
                        extraDetail: errorMessage // optional
                    })
                };
            }
        };
    })();

    /**
     * Holds either the real or mock Agni URLs for testing depending on the <code>um.agni.mock</code> feature flag.
     */
    var AGNI_URLS = (function () {
        var baseUrl = adminApp.isFeatureEnabled('um.agni.mock') ? AJS.contextPath() + '/rest/um/1/mock_agni_server' : '/missioncontrol/rest';
        return {
            gappsDomain: baseUrl + '/gapps-domain',
            startOAuthDance: baseUrl + '/oauth-callback',
            gappsStatus: baseUrl + '/gapps-status'
        };
    })();

    var getGappsStatus = root.helpers.memoize(function () {
        return $.getJSON(AGNI_URLS.gappsStatus).then(undefined, function () {
            return $.get(AGNI_URLS.gappsDomain).then(function (gappsDomain) {
                return {
                    gappsDomain: gappsDomain
                };
            }, function () {
                // return a resolved promise so that the status is no longer "rejected"
                return $.when({});
            });
        });
    });

    /**
     * Renders the GApps status, optionally displaying the linked GApps domain.
     *
     * @param {string} gappsDomain The linked GApps domain (may be empty).
     * @param {string} gappsType The GApps integration type.
     */
    function renderGAppsStatus(gappsDomain, gappsType) {
        UserManagement.models.DefaultApps.fetch().done(function (defaultApps) {
            root.helpers.updateContent(usermanagement.googleapps.show({
                gappsDomain: gappsDomain,
                defaultapps: defaultApps,
                isUpgradePossible: gappsType === LEGACY_GAPPS_TYPE
            }));

            require("helpers/helptip")({
                anchor: "#important-tip-dialog",
                body: usermanagement.googleapps.tipDialog(),
                hideDelay: null,
                offsetX: 200,
                arrowOffsetX: 100
            });
        });
    }

    /**
     * Renders a generic "error contacting Agni" message.
     */
    function renderGAppsError() {
        root.helpers.updateContent(usermanagement.googleapps.agniError());
    }


    var googleAppsHelptipFilter = 'google-apps-helptip';
    Doppelganger.setFilterHandler(googleAppsHelptipFilter, function (routeData) {
        adminApp.app.filterManager.remove(googleAppsHelptipFilter);
        // Do not run this code if we are on a focused task page or anonymous page (the latter implies the former)
        if (!routeData.focusedTask && routeData.params.type !== "googleapps") {
            getGappsStatus().done(function (data) {
                if (data.gappsType === LEGACY_GAPPS_TYPE) {
                    require("helpers/helptip")({
                        anchor: "#lhstab-googleapps",
                        body: usermanagement.googleapps.helptip(),
                        id: 'gapps-upgrade-warning',
                        gravity: "w",
                        noBind: true,
                        persistent: true,
                        offsetX: -50,
                        hideOnFocusedTask: true //for when we transition to a focused task page
                    }).show();
                }
            });
        }
        return routeData;
    });
    adminApp.filterList.push(googleAppsHelptipFilter);


}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));
