(function ($, root, adminApp) {
    root.routes = root.routes || {};
    var appAccessRoutes = root.routes.apps = {};
    var USERS_ADDED_TO_APPLICATIONS_SESSION_KEY = "users.added.to.applications";
    var slugToProductMap = {};
    var idToProductMap = {};
    var flag = require('aui/flag');
    var currentAppId;
    var dataTable;

    var getFullLicenseUsage = root.helpers.memoize(root.helpers.ajax.getLicenseUsage);
    var getProductDescription = root.helpers.memoize(root.helpers.ajax.getApplicationsDescription);

    function slugify(product) {
        components = "application-" + $.trim(product.name)  + "-" + product.id;
        return components
                .toLowerCase()
                .replace(/\s+/g, "-")
                // AUI Tabs uses this value as a selector, so nothing that can be
                // used as a selector can go here.
                .replace(/[!"#$%&'()*+,.\/:;<=>?@[\\\]^`{|}~]/g, "");
    }

    var delaySearch = _.debounce(function (form) {
        $(form).submit();
    }, 200);

    /**
     * A reset method for test purposes
     * @private
     */
    appAccessRoutes._reset = function () {
        currentAppId = undefined;
        dataTable = undefined;
        getFullLicenseUsage.reset();
        getProductDescription.reset();
    };

    appAccessRoutes.list = function (routeData) {
        if (!routeData.appId) {
            appAccessRoutes._reset();
            root.helpers.updateContent(usermanagement.apps.listPrefetch({
                renaissanceDarkFeatureEnabled: adminApp.isFeatureEnabled("um.renaissance")
            }));

            getProductDescription().done(function (licenseUsage) {
                adminApp.app.trigger("list", { type: "apps", replace: true, appId: slugify(licenseUsage[0]) });
            });
        } else {
            var hasAppId = !!currentAppId;
            currentAppId = routeData.appId;
            var previousInput = "";

            if (hasAppId && dataTable && !routeData.licenseChanged) {
                dataTable.setQueryParam("appId", currentAppId);
                dataTable.removeQueryParam(root.UMDataTable.PAGINATION_QUERY_PARAM);
                dataTable.search({
                    pushState: false
                });
            } else {
                root.helpers.updateContent(usermanagement.apps.listPrefetch({
                    renaissanceDarkFeatureEnabled: adminApp.isFeatureEnabled("um.renaissance")
                }));
                var tabsLoaded = getProductDescription().done(function (licenseUsage) {
                    var products = licenseUsage;

                    $.each(products, function (i, product) {
                        slugToProductMap[slugify(product)] = product;
                        idToProductMap[product.id] = product;
                    });

                    // Were users added as part of the previous request?
                    var usersAdded = root.UMFlashData.getOnce(USERS_ADDED_TO_APPLICATIONS_SESSION_KEY);

                    // Classify this function invocation.
                    var isError = arguments[1] === "error";

                    // The data provided to create the tabs now uses a 'slugified' product string for it's id.
                    var tabs = $.map(products, function (product) {
                        var slugified = slugify(product);
                        var withSlugifiedId = $.extend({}, product, {
                            hash: slugified,
                            url: "#" + slugified,
                            text: product.name,
                            isActive: currentAppId === slugified,
                            id: slugified
                        });
                        return withSlugifiedId;
                    });

                    root.helpers.updateContent(usermanagement.apps.list({
                        products: products,
                        tabs: tabs,
                        errorFetching: isError,
                        renaissanceDarkFeatureEnabled: adminApp.isFeatureEnabled("um.renaissance")
                    }));

                    $('#application-access-config').click(function() {
                        adminApp.app.navigate("list", { type: "accessconfig"});
                    });

                    var $pageData = $("#page-data");

                    // Add special class to any products with a negative seat count.
                    $pageData.find(".key-value dd").toggleClass(function (index) {
                        return products[index].seatsAvailable < 0 && "negative-seat-count";
                    });

                    // A collection of lozenges that should be dismissed
                    // next time a tab is clicked.
                    var $associatedTabPanel = $pageData.find(".tabs-pane");

                    $associatedTabPanel.find(".umtable").remove();
                    dataTable = new root.UMDataTable("apps", {
                        container: $associatedTabPanel,
                        searchTriggerContainer: $associatedTabPanel.find(".list-search"),
                        url: function () {
                            if (slugToProductMap[currentAppId]) {
                                return AJS.contextPath() + '/rest/um/1/apps/' + slugToProductMap[currentAppId].id + '/users';
                            }
                        },
                        //sanitize user data.
                        parse: root.routes.users.sanitiseUserData,
                        extraParams: function () {
                            var productId = slugToProductMap[currentAppId].id;
                            return usersAdded && usersAdded[productId] ? {
                                "n": usersAdded[productId]
                            } : {};
                        },
                        loadedCallback: function (table) {
                            if (dataTable !== table) {
                                //user has navigated away from the page.
                                return;
                            }
                            var isError = arguments[1] === "error";
                            dataTable.hideBlanket();

                            // Time out!
                            setTimeout(function () {
                                if (dataTable) { //qunit was sometimes unable to find dataTable - likely due to setTimeout putting this to top of queue
                                    dataTable.inputTextField.focus();
                                }
                            }, 0);

                            // We want to get rid of the extra throbber.
                            $associatedTabPanel.find(".aui-icon-wait").eq(0).remove();

                            if (isError) {
                                AJS.messages.error($associatedTabPanel, {
                                    body: "<p>" + AJS.I18n.getText("usermanagement.apps.could.load.individual.product.seats") + "</p>"
                                });
                            } else {
                                $associatedTabPanel.find(".dataActions").show();
                            }

                            root.helpers.tooltips();

                            var productId = slugToProductMap[currentAppId].id;
                            var activeApplicationAddedUsers = usersAdded && usersAdded[productId];
                            if (activeApplicationAddedUsers) {
                                // Here, we go through the tab pane and add an "added" lozenge next to each one.
                                dataTable.highlightNewRows(function () {
                                    return $.inArray($(this).data("username"), activeApplicationAddedUsers) > -1;
                                });

                                // We want this to "reset" itself after showing
                                // the newly added users, so we delete its cache.
                                delete usersAdded[productId];
                            }
                        }
                    });

                    //If there is a filter in the param list on page load (or after revoke), add it
                    var filterValue = Arg.get('filter');
                    $('#list-search-text').val(filterValue).toggleClass("has-text", !!filterValue);

                    // Fix 'em tabs up.
                    AJS.tabs.setup();

                    // If we're here as a result of adding new users, then we want to choose the
                    // active tab as the first of the newly added to applications. This comes
                    // after we've rendered the tabs.
                    if (usersAdded) {
                        var id = Object.keys && Object.keys(usersAdded)[0];

                        if (!id) {
                            $.each(usersAdded, function (i) {
                                id = i;
                                // We only want this guy to iterate once.
                                // Get your shit together Internet Explorer.
                                return false;
                            });
                        }

                        $.each(products, function (index, product) {
                            if (product.id === id) {
                                $('[href="#' + slugify(product) + '"]').click();
                                return false;
                            }
                        });
                    }

                    // Throbberise the tab panels.
                    $(".tabs-pane").prepend(usermanagement.loading());

                    // Hidify the UMDataTables to begin with.
                    $(".dataActions").hide();

                    if (usersAdded) {
                        $.each(usersAdded, function (productId, productUsersAdded) {
                            // Firstly, we add a count of all users as a "lozenge"
                            // added next to each tab.

                            // The tab's "id" attribute is the slugified product string.
                            $("#" + slugify(idToProductMap[productId])).children("a").append(aui.lozenges.lozenge({
                                text: AJS.I18n.getText("usermanagement.apps.user.added.count.lozenge", productUsersAdded.length),
                                type: "success"
                            }));

                            // Then, on per UMDataTable activation, we sort newly added users
                            // and add a lozenge next to them. Refer to code in the relevant
                            // section.
                        });
                    }

                    //bind a handler for this page's data table. Make sure it unbinds after the user navigates away.
                    var stateChangeTabHandler = function() {
                        if (History.getState().data.params) {
                            if (History.getState().data.params.appId) {
                                AJS.tabs.change($('[href="#' + History.getState().data.params.appId + '"]'));
                            } else {
                                appAccessRoutes._reset();
                                $(window).off('statechange', stateChangeTabHandler)
                            }
                        }
                    };

                    $(window).on('statechange', stateChangeTabHandler);
                });

                $.when(tabsLoaded, getFullLicenseUsage()).done(function(ignore, licenseUsage) {
                    var isError = arguments[2] === "error";
                    if (!isError) {
                        $('#application-seat-info').replaceWith(usermanagement.keyValues({
                            data: root.helpers.applicationDataMappers.productsToSeatsAvailableMessages(licenseUsage)
                        }));
                    }
                });
            }

            return {
                events: {
                    'submit #apps-list-search': function (e) {
                        e.preventDefault();
                        var filterText = dataTable.inputTextField.val();
                        //Blow away old pagination
                        dataTable.setQueryParam(root.UMDataTable.SEARCH_QUERY_PARAM, filterText);
                        dataTable.removeQueryParam(root.UMDataTable.PAGINATION_QUERY_PARAM);
                        dataTable.search();
                        dataTable.inputTextField.focus();
                    },
                    'click .clear-search': function () {
                        dataTable.inputTextField.val("").removeClass("has-text");
                        //Blow away all old filters and pagination
                        dataTable.removeQueryParam(root.UMDataTable.SEARCH_QUERY_PARAM);
                        dataTable.removeQueryParam(root.UMDataTable.PAGINATION_QUERY_PARAM);
                        dataTable.showBlanket();
                        dataTable.search();
                        dataTable.inputTextField.focus();
                    },
                    // cut and keyup event for IE9
                    'input,keyup,cut #list-search-text': function () {
                        var searchValue = $.trim(this.value);
                        var hasInput = !!searchValue;
                        dataTable.inputTextField.toggleClass("has-text", hasInput);
                        // Make sure the searched text is actually different.
                        if (searchValue !== previousInput) {
                            previousInput = searchValue;
                            dataTable.toggleBlanket(true);
                            delaySearch(this.form);
                        }
                    },
                    'click .aui-nav-pagination': function (e) {
                        dataTable.paginationEvent(e);
                    },
                    'click #set-defaults': function () {
                        adminApp.app.trigger("set-defaults", { type: "apps" });
                    },
                    'click .menu-item a': function (e) {
                        e.preventDefault();

                        // Hide them lozenges gracefully.
                        var $tab = $('[href="#' + currentAppId + '"]');
                        var $lozenge = $tab.children(".aui-lozenge");

                        $lozenge.show();

                        $lozenge.fadeOut(300, function () {
                            $(this).remove();
                        });

                        adminApp.app.navigate('list', { type: 'apps', appId: $(this).attr("href").slice(1) });
                    },
                    'click .revoke-access': function () {
                        var product = slugToProductMap[currentAppId];
                        var userName = $(this).attr("data-username");

                        $.ajax(AJS.contextPath() + "/rest/um/1/user/access?username=" + encodeURIComponent(userName) + "&productId=" + encodeURIComponent(product.id), {
                            type: "delete"
                        }).fail(function (jqXhr) {
                            try {
                                flag({
                                    type: "error",
                                    body: JSON.parse(jqXhr.responseText).errors[0].message
                                });
                            } catch (e) {
                                flag({
                                    type: "error",
                                    body: AJS.I18n.getText("usermanagement.apps.user.revoked.access.to.product.error", userName, product.name)
                                });
                            }

                            adminApp.app.trigger('list', { type: 'apps', appId: currentAppId, licenseChanged: true });
                        }).done(function () {
                            flag({
                                type: "success",
                                close: 'auto',
                                body: AJS.I18n.getText("usermanagement.apps.user.revoked.access.to.product", userName, product.name)
                            });

                            getFullLicenseUsage.reset();
                            getProductDescription.reset();
                            adminApp.app.trigger('list', { type: 'apps', appId: currentAppId, licenseChanged: true });
                        });
                    }
                }
            };
        }
    };

    appAccessRoutes.add = function (routeData) {
        root.helpers.updateContent(usermanagement.apps.addUsersToApplicationsPrefetch());
        root.helpers.ajax.getLicenseUsage().done(function (licenseUsage) {
            var apps = licenseUsage.products;
            root.helpers.updateContent(usermanagement.apps.addUsersToApplications({
                applications: root.helpers.applicationDataMappers.formatApplications({
                    applications: apps,
                    accessLevels: routeData.selectedApplications,
                    autoUpgradeMode: licenseUsage.autoUpgradeMode
                }),
                groups: root.helpers.applicationDataMappers.formatGroups(apps)
            }));
            root.ApplicationCheckboxController.configureApplicationCheckboxRelationships(licenseUsage, '#applications');

            var $form = $("#grant-access");

            // Make sure the right radio box is selected when
            // the user starts doing their thing.
            $form.find("> ul > li").change(function () {
               $(this).find("input[type='radio']").click();
            });

            var $input = $("#users");

            var picker = root.helpers.users.setupMultipleUserPicker({
                element: $input,
                userFilters: ["users"],
                autoFocus: routeData.usersType === undefined || routeData.usersType === "users",
                defaultSelection: routeData.selectedUsers,
                preventInactive: true
            });

            var $select2Container = $("#s2id_users");

            $input.change(function () {
                $select2Container.toggleClass("has-selection", !!this.value);
            });

            $input.change();

            var $checkboxes = $form.find("#applications input[type='checkbox']").filter(function () {
                return $.inArray(this.id, root.helpers.applicationDataMappers.filterApplicationWithAvailableSeats(apps)) >= 0;
            });
            var $groupPicker = $form.find("#user-groups");

            if (routeData.usersType) {
                $form.find("[name='users-type'][value='" + routeData.usersType + "']").prop('checked', true);
            }

            if (routeData.selectedGroup) {
                $groupPicker.val(routeData.selectedGroup);
                if (routeData.usersType !== "users") {
                    $groupPicker.focus();
                }
            }

            var showGrantAccessResultMessage = function (data, isSuccess) {
                var body = "",
                    users, productName;

                if (isSuccess) {

                    root.UMFlashData.set(USERS_ADDED_TO_APPLICATIONS_SESSION_KEY, data);

                } else {
                    $.each(data, function (key, value) {
                        if (value.length != 0) {
                            users = value.join(", ");
                            productName = $('input[value="' + key + '"]').parent('div').attr('name');
                            body += "<li>" + AJS.I18n.getText("usermanagement.apps.users.granted.access.to.product.detail", AJS.escapeHtml(productName), AJS.escapeHtml(users)) + "</li>";
                        }
                    });

                    flag({
                        type: "warning",
                        title: AJS.I18n.getText("usermanagement.apps.users.granted.access.to.product.error"),
                        body: "<ul>" + body + "</ul>"
                    });
                }
            };

            var displayGrantAccessResult = function (data) {
                if (data && !$.isEmptyObject(data)) {

                    var successes = {}, failures = {};

                    $.map(data, function (v, k) {
                        if (v.successes && v.successes.length > 0) successes[k] = v.successes;
                        if (v.failures && v.failures.length > 0) failures[k] = v.failures;
                    });

                    if (!$.isEmptyObject(successes)) {
                        showGrantAccessResultMessage(successes, true);
                    }

                    if (!$.isEmptyObject(failures)) {
                        showGrantAccessResultMessage(failures, false);
                    }
                }
            };

            var displayLicenseExceededResult = function (data) {
               return UserManagement.helpers.error.displayLicenceExceededErrorInDetail(data);
            };

            var displayAppFailureResult = function (data) {
                if (data && !$.isEmptyObject(data)) {
                    var title = AJS.I18n.getText("usermanagement.apps.users.granted.access.to.product.error"),
                        body = "";

                    $.each(data, function (key, value) {
                        var productName = $('input[value="' + key + '"]').parent('div').attr('name');
                        body += "<li>" + AJS.I18n.getText("usermanagement.apps.generic.error", productName, value) + "</li>";
                    });

                    flag({
                        type: "error",
                        title: title,
                        body: "<ul>" + body + "</ul>"
                    });
                }
            };

            new root.UMForm($form, 'POST', {
                presubmitValidator: function (validation) {
                    if ($checkboxes.filter(function () { return this.checked;}).length < 1) {
                        validation.addFieldError('applications', AJS.I18n.getText('usermanagement.apps.select.at.least.one.error'));
                    }
                    if ($form.find("[name='users-type']:checked").val() === 'users' && $select2Container.select2('val').length === 0) {
                        validation.addFieldError('users', AJS.I18n.getText('usermanagement.apps.select.at.least.one.user.error'));
                    }
                },
                dataFormatter: function (data) {
                    var productIds = root.helpers.applicationDataMappers.filterFakeCheckedApplications(data.applications, licenseUsage.products);

                    if (data["users-type"] === "users") {
                        return {
                            users: $.map(picker.getUsers(), function (user) { return user.id; }),
                            productIds: productIds
                        };
                    } else {
                        return {
                            group: data["user-groups"],
                            productIds: productIds
                        };
                    }
                }
            })
            .on('done', function (data) {
                // handles the case where license is not exceeded
                displayGrantAccessResult(data.completed);

                if ( (data.licenseExceeded && !$.isEmptyObject(data.licenseExceeded) )||
                     (data.aborted && !$.isEmptyObject(data.aborted))) {
                    // handles the case where license is exceeded
                    var availableApps = displayLicenseExceededResult(data.licenseExceeded);

                    displayAppFailureResult(data.aborted);

                    // re-populate user input
                    adminApp.app.trigger('add', {
                        type: 'apps',
                        usersType: $form.find("input:radio[name='users-type']:checked").val(),
                        selectedUsers: picker.getUsers(),
                        selectedGroup: $groupPicker.val(),
                        selectedApplications: availableApps
                    });
                } else {
                    adminApp.app.navigate('list', {type: 'apps'});
                }
            });
        });

        return {
            focusedTask: true
        };
    };

    appAccessRoutes["set-defaults"] = function () {

        getFullLicenseUsage().done(function (licenceUsage) {
            var hasSubProductChecked = function(currentProduct, productList) {
                for (var i = 0; i < productList.length; i++) {
                    var product = productList[i];
                    if (product.platformProductName === currentProduct.name && product.isDefault) {
                        return true;
                    }
                }
                return false;
            };

            var domElementHasSubProductChecked = function (domElement, productList) {
                for (var i = 0; i < productList.length; i++) {
                    var currentProduct = productList[i];
                    if (currentProduct.platformProductName === domElement.name
                        && $('input.checkbox[value="' + currentProduct.id + '"]').prop('checked')) {
                            return true;
                    }
                }
                return false;
            };

            var productDefaults = $.map(licenceUsage.products, function (product) {

                var checkedSubProduct = hasSubProductChecked(product, licenceUsage.products);

                return {
                    id: product.id + "-modal",
                    name: product.name,
                    value: product.id,
                    labelText: product.name,
                    isChecked: product.isDefault || checkedSubProduct,
                    isDisabled: checkedSubProduct,
                    extraAttributes: {
                        'isServerChecked' : product.isDefault
                    }
                };
            });

            var dialog = new root.UMModal({
                template: usermanagement.apps.setDefaults({ productDefaults: productDefaults }),
                title: AJS.I18n.getText('usermanagement.apps.set.defaults.title'),
                submitButton: AJS.I18n.getText('usermanagement.apps.set.defaults.button')
            });
            var $form = $('#application-access-defaults');

            root.ApplicationCheckboxController.configureApplicationCheckboxRelationships(licenceUsage, '.group', true);

            new root.UMForm($form, 'PUT', {
                dataFormatter: function () {
                    var data = {};
                    $form.find("input[type='checkbox']").map(function () {
                        return data[this.value] = $(this).parent().attr('isServerChecked') === "true" && !domElementHasSubProductChecked(this, licenceUsage.products)
                    });
                    return data;
                }
            })
            .on('done', function () {
                flag({
                    type: "success",
                    close: 'auto',
                    body: AJS.I18n.getText("usermanagement.apps.defaults.updated")
                });
                dialog.remove();
                adminApp.app.trigger('list', { type: 'apps' });
            });
        });

        return {
            partial: true
        };
    };

})(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp);
