(function ($, root) {
    root.routes = root.routes || {};
    var accessConfigRoutes = root.routes.accessconfig = {};
    var helpers = root.helpers;

    var checkboxLoad = function(checkbox, loading) {
        var className = 'mark-loading';
        var td = checkbox.closest('td');
        if (loading) {
            td.addClass(className);
        } else {
            td.removeClass(className);
        }
    };

    var refreshRow = function($tr, overrides) {
        var $product = $tr.closest('tbody');
        var productName = $product.data('product-name');
        var hostId = $product.data('host-id');
        var platformName = $product.parent().children('.platform[data-host-id="' + hostId + '"]').data('product-name');
        
        var $newTr = $(usermanagement.accessconfig.group({
            productName: productName,
            platformProductName: platformName,
            productConfigurable: true,
            group: $.extend(toGroup($tr), overrides),
            isNew: $tr.find('.aui-lozenge.new').length
        }));
        $tr.html($newTr.html());
        if ($newTr.hasClass('default')) {
            $tr.addClass('default');
        } else {
            $tr.removeClass('default');
        }
    };

    var toGroup = function($tr) {
        if ($tr.find('.approval').length) {
            return {
                name: $tr.data('group-name'),
                use: $tr.hasClass('use') ? 'DIRECT' : 'NONE',
                admin: $tr.hasClass('admin') ? 'DIRECT' : 'NONE',
                defaultUse: $tr.hasClass('default'),
            };
        } else {
            return {
                name: $tr.data('group-name'),
                use: getAccessLevel($tr.children('.use').find('input')),
                admin: getAccessLevel($tr.children('.admin').find('input')),
                defaultUse: $tr.hasClass('default'),
            };
        }
    };

    var getAccessLevel = function($input) {
        return $input.data('disabled') === true ? 'DISABLED' : $input.is(':checked') ? 'DIRECT' : 'NONE';
    };

    var tooltips = function() {
        $('.aui-page-panel-content').find('.aui-lozenge[title]').tooltip();
    };

    var initHelpDialogs = function() {
        var $helpIcons = $('.access-config').find('.aui-icon.aui-iconfont-help');
        var dialog = new AJS.InlineDialog(
            $helpIcons,
            AJS.id('help-dialog'),
            function(content, trigger, showPopup) {
                content.empty().append($(trigger).parent().find('.help-icon-desc').clone());
                showPopup();
                dialog.refresh();
            },
            {
                offsetX: -100,
                onHover: true,
                gravity: 's'
            }
        );
        
        if ($('.approval').length) {
            var dialog = new root.UMModal({
                template: usermanagement.accessconfig.pendingConfirmationDialog(),
                title: AJS.I18n.getText('usermanagement.accessconfig.unapproved.dialog.header'),
                cancelText: AJS.I18n.getText('usermanagement.generic.close')
            });
        }
    };

    var updateLastAdmin = function($product) {
        if ($product.data('product-configurable')) {
            var $admins = $product.find('td.admin > input:checked');
            if ($admins.length === 1) {
                $admins.attr({
                    title: AJS.I18n.getText('usermanagement.accessconfig.last.admin'),
                    disabled: "disabled"
                });
            } else {
                $admins.removeAttr("title").removeAttr("disabled");
            }
        }
    };

    var updateLastGroups = function() {
        $('tbody').each(function(i) {
            updateLastAdmin($(this));
            updateLastUse($(this));
            updateProductLastDefault($(this));
            $(this).attr("data-table-uuid", window.uuid.v4());
        });
    };

    var updateProductLastDefault = function($product) {
        var defaultRows = $product.find('tr.default');
        var currentLastDefault = defaultRows.find('.last-default');
        var defaultContent;

        if (defaultRows.length === 1 && currentLastDefault.length === 0) {
            defaultContent = defaultRows.find('.defaults-wrapper').children();
            $(usermanagement.accessconfig.lastDefault()).replaceAll(defaultContent);
        } else if(currentLastDefault.length !== 0) {
            refreshRow(currentLastDefault.closest('tr'));
        }
    };

    var updateProductLastGroups = function ($product) {
        updateLastAdmin($product);
        updateLastUse($product);
        $product.attr("data-table-uuid", window.uuid.v4());
    };

    var updateLastUse = function($product) {
        if ($product.data('product-configurable')) {
            var $use = $product.find('td.use > input:checked');
            if ($use.length === 1) {
                $use.attr({
                    title: AJS.I18n.getText('usermanagement.accessconfig.invalid.cant.remove.last.use'),
                    disabled: "disabled"
                });
            } else {
                $use.each(function () {
                    //Only enable those without default access
                    if (!$(this).parents('tr').hasClass("default"))
                    {
                        $(this).removeAttr("title").removeAttr("disabled");
                    }
                });
            }
        }
    };

    accessConfigRoutes.list = function () {
        helpers.updateContent(usermanagement.accessconfig.tablePrefetch());

        helpers.ajax.getAccessConfig().done(function (config) {
            helpers.updateContent(usermanagement.accessconfig.table(config));
            //display the changehub dialog if its within the renaissance warning period
            helpers.triggerChangeHub("#changehub-accessconfig-onboarding", "AccessConfig");
            updateLastGroups();
            tooltips();
            initHelpDialogs();
        });

        return {
            events: {
                'click #changehub-accessconfig-onboarding #changehub-accessconfig-confirm' : function () {
                    sessionStorage["changeHubAccessConfigDialogSeen-" + $("meta[name='remote-username']").attr("content")] = true;
                    AJS.dialog2("#changehub-accessconfig-onboarding").remove();
                },
                'click #changehub-accessconfig-onboarding #changehub-accessconfig-dont-show' : function () {
                    localStorage["changeHubAccessConfigDialogDontShow-" + $("meta[name='remote-username']").attr("content")] = true;
                    AJS.dialog2("#changehub-accessconfig-onboarding").remove();
                },
                'click .access-config input[type="checkbox"]': function () {
                    var $this = $(this);

                    var loading = _.partial(checkboxLoad, $this);
                    loading(true);

                    var $product = $this.closest('tbody');
                    var $tr = $this.closest('tr');

                    helpers.ajax.updateGroup($product.data('host-id'), $product.data('product-id'), toGroup($tr))
                        .done(function () {
                            loading(false);

                            // if no checkboxes are checked, remove the row
                            if (!$tr.find('input:checked').length) {
                                $tr.addClass('deleteHighlight').fadeOut('fast', function () {
                                    $(this).remove();
                                    updateProductLastGroups($product);
                                });
                            } else {
                                refreshRow($tr);
                                updateProductLastGroups($product);
                            }
                        })
                        .fail(function () {
                            loading(false);
                            $this.attr('checked', false);
                        });
                },
                'click .make-default, .make-non-default': function (e) {
                    e.preventDefault();
                    var $this = $(this);
                    var defaultUse = $this.is('.make-default');

                    var loading = _.partial(checkboxLoad, $this);
                    loading(true);

                    var $product = $this.closest('tbody');
                    var hostId = $product.data('host-id');
                    var productId = $product.data('product-id');

                    var $tr = $this.closest('tr');
                    var group = toGroup($tr);
                    group.defaultUse = defaultUse;

                    helpers.ajax.updateGroup(hostId, productId, group)
                        .done(function () {
                            loading(false);
                            $this.remove();

                            refreshRow($tr, {
                                defaultUse: defaultUse
                            });
                            updateProductLastDefault($product);
                            tooltips();
                        }).fail(function () {
                            loading(false);
                        });
                },
                'click .access-config .reject': function(e) {
                    e.preventDefault();
                    var $this = $(this);

                    var loading = _.partial(checkboxLoad, $this);
                    loading(true);

                    var $product = $this.closest('tbody');
                    var hostId = $product.data('host-id');
                    var productId = $product.data('product-id');

                    var $tr = $this.closest('tr');
                    var group = toGroup($tr);

                    helpers.ajax.rejectGroupAccess(hostId, productId, group)
                        .done(function () {
                            $tr.addClass('deleteHighlight').fadeOut('fast', function () {
                                $(this).remove();
                            });
                        }).fail(function () {
                            loading(false);
                        });
                },
                'click .access-config .approve': function(e) {
                    e.preventDefault();
                    var $this = $(this);

                    var loading = _.partial(checkboxLoad, $this);
                    loading(true);

                    var $product = $this.closest('tbody');
                    var hostId = $product.data('host-id');
                    var productId = $product.data('product-id');

                    var $tr = $this.closest('tr');
                    var group = toGroup($tr);
                    
                    helpers.ajax.approveGroupAccess(hostId, productId, group)
                        .done(function () {
                            loading(false);

                            refreshRow($tr, group);
                            tooltips();
                            updateProductLastGroups($product);
                        }).fail(function () {
                            loading(false);
                        });
                    
                },
                'click .add-group': function () {
                    var $this = $(this);
                    var $product = $this.closest('tbody');
                    var hostId = $product.data('host-id');
                    var productId = $product.data('product-id');
                    var productName = $product.data('product-name');
                    var platformName = $product.parent().children('.platform[data-host-id="' + hostId + '"]').data('product-name');

                    var dialog = new root.UMModal({
                        height: 200,
                        template: usermanagement.accessconfig.addGroup({
                            hostId: hostId,
                            productId: productId
                        }),
                        title: AJS.I18n.getText('usermanagement.accessconfig.groups.grant.title', $product.children('.product-header').text()),
                        submitButton: AJS.I18n.getText('usermanagement.accessconfig.groups.grant')
                    });

                    var $parentGroup = $("#parentGroup");

                    var groupPicker = helpers.groups.setupGroupPicker({
                        $element: $parentGroup,
                        multiple: true,
                        autoFocus: true
                    });

                    var UMFormOptions = {
                        dataFormatter: function (data) {
                            data = [];
                            $.each(groupPicker.getGroups(), function (index, group) {
                                data.push(group.id);
                            });
                            return data;
                        }
                    };

                    new root.UMForm('#access-add-group', 'POST', UMFormOptions)
                        .on('done', function (data) {
                            $.each(data, function (index, group) {
                                $(usermanagement.accessconfig.group({
                                    productConfigurable: true,
                                    productName: productName,
                                    platformProductName: platformName,
                                    group: group,
                                    isNew: true
                                })).insertAfter($product.children('.inner-table-header'));
                            });
                            tooltips();

                            dialog.remove();
                            updateProductLastGroups($product);
                        });

                    helpers.select2.resizeModalBasedOnHeight($parentGroup, dialog);
                }
            }
        };
    };

}(AJS.$, window.UserManagement = window.UserManagement || {}));
