/**
 * This script displays an informational message with a link to drop the impersonation, if the current user is
 * being impersonated. This script is used in both user management and user provisioning plugins.
 */
(function ($) {
    var flag = optional('aui/flag'); // aui-flag may not be available in products that use older versions of AUI
    var cookies = UserManagement.helpers.cookies;

    if (cookies.readCookie("um.user.impersonated.username")) {
        $(function () {
            var message = AJS.I18n.getText("usermanagement.users.loginas.impersonationactive",
                        _.escape(cookies.readCookie("um.user.impersonated.displayname")),
                        '<a id="impersonation-dismiss-trigger">', '</a>');

            // use aui-flag if available, otherwise fall back to AJS.messages
            var messageFlag = flag ? flag({ type: 'info', body: message })
                                   : AJS.messages.warning(".notifications", { body: message });
            
            $(messageFlag).find("#impersonation-dismiss-trigger").click(function (e) {
                var username = cookies.readCookie("um.user.impersonated.username"); // Cookies will be wiped when the ajax returns, so store it locally now
                e.preventDefault();
                $.ajax({
                    type: "POST",
                    url: "/admin/rest/um/1/impersonate/release"
                }).done(function () {
                    window.location = "/admin/users/view?username=" + encodeURIComponent(username);
                });
            });
        });
    }

    /**
     * Load an optional AMD module
     *
     * @param module the AMD module key
     * @returns the dependency if found, otherwise undefined
     */
    function optional(module) {
        try {
            return require(module);
        } catch (e) { }
    }

})(AJS.$);