;(function(){

    /**
     * @param {string} selector - A selector which will identify the dialog
     * @param {string} key - a key used for session storage; If 2 dialogs share a key they will share preferences
     */
    AJS.namespace("UserManagement.helpers.triggerChangeHub", function (selector, key) {
        var products = JSON.parse(AJS.$('meta[name="products"]').attr("content") || "[]");
        var username = AJS.$("meta[name='remote-username']").attr("content");
        var showWarning = AJS.$("meta[name='show-renaissance-warning']").attr("content") == "true";
        var migrationDate = +AJS.$("meta[name='renaissance-migration']").attr("content") || 0;
        var userCreationDate = +sessionStorage["userCreationDate-" + username] || 0;
        var dialogSeen = sessionStorage["changeHub" + key + "DialogSeen-" + username];
        var dialogDontShow = localStorage["changeHub" + key + "DialogDontShow-" + username];
        // make sure they have JIRA and they havn't chosen to hide it
        if(_.contains(products, "jira") && !dialogDontShow && !dialogSeen) {
            // Check that it is after the 'display warning' date
            if (showWarning) {
                //check that the current admin was created before the migration
                if (migrationDate === 0){
                    //break early to avoid AJAX call if we have no migration date to check it against
                    AJS.dialog2(selector).show();
                } else {
                    if (!userCreationDate) {
                        //Retrieve creation date from server and cache
                        AJS.$.getJSON(AJS.contextPath() + '/rest/um/1/user', {
                            username: username,
                            expand: 'attributes'
                        }).then(function (data) {
                            var user = UserManagement.helpers.users.sanitiseAndMapUserData(data);
                            userCreationDate = sessionStorage["userCreationDate-" + username] = +new Date(user.createdDate.isoString);
                            if (migrationDate > userCreationDate) {
                                AJS.dialog2(selector).show();
                            }
                        });
                    } else {
                        // already have a cached creation date
                        if (migrationDate > userCreationDate) {
                            AJS.dialog2(selector).show();
                        }
                    }
                }
            }
        }
    });
})();