(function($, root) {
    var flag = require('aui/flag');
    var showErrorsFlag = function(jqXhr) {
        try {
            flag({
                type: "error",
                close: "manual",
                body: JSON.parse(jqXhr.responseText).errors[0].message
            });
        } catch (e) {
            flag({
                type: "error",
                close: "manual",
                body: AJS.I18n.getText('usermanagement.application.unknown.error')
            });
            AJS.log(e, jqXhr);
        }
        return jqXhr;
    };

    root.helpers = root.helpers || {};
    root.helpers.ajax = {
        getApplicationsDescription: function () {
            //Only gets the name and ID of each application, but is significantly faster than full licence info
            return $.getJSON(AJS.contextPath() + '/rest/um/1/apps/description').then(function (data) {
                return data;
            });
        },
        getApplications: function () {
            return $.getJSON(AJS.contextPath() + '/rest/um/1/apps/defaults').then(function (data) {
                return data;
            });
        },
        getApplicationWithSeats: function () {
            return $.getJSON(AJS.contextPath() + '/rest/um/1/apps/seats').then(function (data) {
                return data;
            });
        },
        getPasswordPolicy: function () {
            return $.getJSON(AJS.contextPath() + '/rest/um/1/passwordpolicy').then(function (data) {
                return data;
            });
        },
        getLicenseUsage: function () {
            return $.when(root.helpers.ajax.getApplicationWithSeats(), root.helpers.ajax.getAutoUpgradeMode()).then(function (products, autoUpgradeMode) {
                return {
                    products: products,
                    autoUpgradeMode: autoUpgradeMode
                };
            });
        },
        getAutoUpgradeMode: function () {
            return $.getJSON(AJS.contextPath() + '/rest/billing/1/instance/is-auto-upgrade').then(function (response) {
                return {
                    enabled: !!(response && response.autoUpgrade),
                    errorGettingValue: false
                };
            }, function (error) {
                // wrap in a resolved promise so that the status is no longer "rejected"
                return $.when({
                    enabled: false,
                    errorGettingValue: error.status !== 404
                });
            });
        },
        getUser: function(username) {
            return $.getJSON(AJS.contextPath() + '/rest/um/1/user', {
                username: username
            });
        },
        getUserCount: function(max){
            var max = max || 30;
            return $.getJSON(AJS.contextPath() + '/rest/um/1/user/search?max-results=' + max)
                .then(function(data){
                    return data.length;
                });
        },
        getAccessConfig: function(){
            return $.getJSON(AJS.contextPath() + '/rest/um/1/accessconfig');
        },
        updateGroup: function(hostId, productId, group){
            return $.ajax({
                url: AJS.contextPath() + "/rest/um/1/accessconfig/group" +
                    "?hostId=" + encodeURIComponent(hostId) +
                    "&productId=" + encodeURIComponent(productId),
                dataType: 'json',
                type: "put",
                contentType: 'application/json',
                data: JSON.stringify(group)
            }).fail(showErrorsFlag);
        },
        approveGroupAccess: function(hostId, productId, group){
            var groupName = group.name;
            return $.ajax({
                url: AJS.contextPath() + "/rest/um/1/accessconfig/group/approval?hostId=" + encodeURIComponent(hostId) + "&productId=" + encodeURIComponent(productId) + '&groupname=' + groupName,
                dataType: 'json',
                type: "post",
                contentType: 'application/json'
            }).fail(showErrorsFlag);
        },
        rejectGroupAccess: function(hostId, productId, group){
            var groupName = group.name;
            return $.ajax({
                url: AJS.contextPath() + "/rest/um/1/accessconfig/group/approval?hostId=" + encodeURIComponent(hostId) + "&productId=" + encodeURIComponent(productId) + '&groupname=' + groupName,
                dataType: 'json',
                type: "delete",
                contentType: 'application/json'
            }).fail(showErrorsFlag);
        },
        deactivateUser: function(username) {
            return $.ajax({
                type: 'POST',
                url: AJS.contextPath() + '/rest/um/1/user/deactivate?username=' + encodeURIComponent(username)
            });
        },
        activateUser: function(username) {
            return $.ajax({
                type: 'POST',
                url: AJS.contextPath() + '/rest/um/1/user/activate?username=' + encodeURIComponent(username)
            });
        },
        logoutUser: function() {
            return $.ajax({
                type: 'POST',
                url: '/logout'
            }).done(function(){
                window.location = '/';
            });
        }
    };
})(AJS.$, window.UserManagement = window.UserManagement || {});