(function(BrowserMetrics){
    /**
     * Filter responsible for registering apdex callbacks for pages inside global admin.
     */
    var apdexFilter = function(routeData){
        var trackedPageName;
        var pageType;
        var readyStates;
        var readyStateSelector;
        /**
         * Keys are destinations(routeData.destination) to track and values are ready state selectors for those pages.
         */
        var pagesToTrack = {
            "list": {
                "users": 'table.umtable tbody tr, .no-results-message',
                "groups": 'table.umtable tbody tr, .no-results-message',
                "apps": 'table.umtable tbody tr, .no-results-message',
                "signup": '#signup-domains-form',
                "passwordpolicy": '#password-reset-button'
            },
            "detail": {
                "users": 'table.umtable tbody tr, .no-results-message',
                "groups": 'table.umtable tbody tr, .no-results-message'
            },
            "add": {
                "users": '#user-edit-add',
                "groups": '#group-edit-add',
                "apps": '#grant-access'
            },
            "delete": {
                "users": '#user-delete',
                "groups": '#group-delete'
            },
            "invite": {
                "users": '#user-create'
            }
        };

        if (BrowserMetrics && routeData.destination && routeData.params && routeData.params.type) {
            pageType = routeData.params.type;
            readyStates = pagesToTrack[routeData.destination];
            readyStateSelector = readyStates && readyStates[pageType];

            //Ensure we're on a page that we want to track before calling BrowserMetrics
            if (readyStateSelector) {
                readyStateSelector = readyStates[pageType];
                trackedPageName = pageType + '-' + routeData.destination;
                try {
                    BrowserMetrics.start({
                        key: "browser.metrics.cpt." + trackedPageName,
                        ready: readyStateSelector
                    });
                } catch (e) {
                    var message = "Browser metrics failed to start.";
                    console.error ? console.error(message) : console.log(message);
                }
            }

        }

        return routeData;
    };

    Doppelganger.setFilterHandler('ApdexFilter', apdexFilter);
})(window["browser-metrics"]);