(function ($) {
    var start;
    Doppelganger.setFilterHandler("timer", function () {
        start = Date.now();
    });
    $(function () {
        adminApp.app.filterManager.add(["timer"]);
    });

    $(document)
        .on("submit", "#user-create", function () {
            var end = Date.now();
            UserManagement.helpers.triggerAnalytics("user.create.new.success", {
                addresses: $("#emailAddresses").auiSelect2("val").length,
                duration: end - start
            });
        })
        .on("click", "#create-user-button", function () {
            UserManagement.helpers.triggerAnalytics("user.create.new.page");
        })
        .on("submit", "#user-edit-add", function () {
            if (this.attributes.action.value === AJS.contextPath() + "/rest/um/1/signup") {
                UserManagement.helpers.triggerAnalytics("user.signup.success");
            }
         })
        .on("change", "#user-create [name='applications']", function () {
            UserManagement.helpers.triggerAnalytics("user.create.applicationToggle");
         })
        .on("click", "#user-create .cancel", function () {
            var end = Date.now();
            UserManagement.helpers.triggerAnalytics("user.create.new.cancel", {
                duration: end - start
            });
        })
        .on("click", "#lhstab-apps", function () {
            UserManagement.helpers.triggerAnalytics("sidebar.apps");
        })
        .on("click", "#lhstab-groups", function () {
            UserManagement.helpers.triggerAnalytics("sidebar.groups");
        })
        .on("click", "#lhstab-users", function () {
            UserManagement.helpers.triggerAnalytics("sidebar.users");
        })
        .on("click", "#lhstab-signup", function () {
            UserManagement.helpers.triggerAnalytics("sidebar.signup");
        })
        .on("click", "#edit-user-button", function () {
            UserManagement.helpers.triggerAnalytics("user.edit");
        })
        .on("click", "#add-group-button", function () {
            UserManagement.helpers.triggerAnalytics("user.addGroup.click");
        })
        .on("submit", "#user-add-group", function () {
            UserManagement.helpers.triggerAnalytics("user.addGroup.submit", {
                groups: $("#parentGroup").auiSelect2("val").length,
                userActive: !$('#user-name-title').hasClass('disabled-text')
            });
        })
        .on("click", "#change-password-button", function () {
            UserManagement.helpers.triggerAnalytics("user.changePassword.click");
        })
        .on("submit", "#user-change-password", function () {
            UserManagement.helpers.triggerAnalytics("user.changePassword.submit");
        })
        .on("click", "#delete-user-button", function () {
            UserManagement.helpers.triggerAnalytics("user.delete.click");
        })
        .on("submit", "#user-delete", function () {
            UserManagement.helpers.triggerAnalytics("user.delete.submit");
        })
        .on("click", "#create-group-button", function () {
            UserManagement.helpers.triggerAnalytics("group.create.click");
        })
        .on("submit", '.aui-page-panel-content #group-edit-add', function () {
                UserManagement.helpers.triggerAnalytics("group.creation.submission");
        })
        .on("click", ".aui-iconfont-remove", function () {
            UserManagement.helpers.triggerAnalytics("group.delete.inline");
        })
        .on("click", "#delete-group-button", function () {
            UserManagement.helpers.triggerAnalytics("group.delete.click");
        })
        .on("submit", "#group-delete", function () {
            UserManagement.helpers.triggerAnalytics("group.delete.submit");
        })
        .on("click", "#add-group-member", function () {
            UserManagement.helpers.triggerAnalytics("group.add.click");
        })
        .on("submit", "#add-user-to-group", function () {
            UserManagement.helpers.triggerAnalytics("group.add.submit", {
                users: $("#users").auiSelect2("val").length,
                inactiveUsers: $('.select2-search-choice .select2-deactivated-user').length
            });
        })
        .on("click", "#edit-group-button", function () {
            UserManagement.helpers.triggerAnalytics("group.edit.click");
        })
        .on("submit", ".dialog-components #group-edit-add", function () {
            UserManagement.helpers.triggerAnalytics("group.editing.submission");
        })
        .on("click", "#add-application-access", function () {
            UserManagement.helpers.triggerAnalytics("application.grant.click");
        })
        .on("submit", "#grant-access", function () {
            var users = $("[name='users-type'][value='users']").prop("checked");
            if (users) {
                UserManagement.helpers.triggerAnalytics("application.grant.submit", {
                    type: "users",
                    users: $("#users").auiSelect2("val").length,
                    inactiveUsers: $('.select2-search-choice .select2-deactivated-user').length
                });
            } else {
                UserManagement.helpers.triggerAnalytics("application.grant.submit", {
                    type: "groups",
                    all: $("#user-groups").val() === "all"
                });
            }
        })
        .on("change", "#applications [type='checkbox']", function () {
            UserManagement.helpers.triggerAnalytics("application.grant.applicationToggle");
        })
        .on("click", "#set-defaults", function () {
            UserManagement.helpers.triggerAnalytics("application.setdefaults.click");
        })
        .on("submit", "#application-access-defaults", function () {
            UserManagement.helpers.triggerAnalytics("application.setdefaults.submit");
        })
        .on("click", "#app-switcher .nav-link-label", function () {
            UserManagement.helpers.triggerAnalytics("header.appswitcher", {
                app: this.textContent
            });
        })
        .on("click", "#admin-dropdown a", function () {
            UserManagement.helpers.triggerAnalytics("header.admin", {
                app: this.textContent
            });
        })
        .on("click", "#helpLink", function () {
            UserManagement.helpers.triggerAnalytics("header.help");
        })
        .on("click", "#logoutLink", function () {
            UserManagement.helpers.triggerAnalytics("header.logout");
        })
        .on("click", "#logo", function () {
            UserManagement.helpers.triggerAnalytics("header.logo");
        })
        .on("submit", "#users-list-search", function () {
            UserManagement.helpers.triggerAnalytics("user.search");
        })
        .on("submit", "#groups-list-search", function () {
            UserManagement.helpers.triggerAnalytics("group.search");
        })
        .on("click", ".users.aui-nav-pagination a", function () {
            UserManagement.helpers.triggerAnalytics("user.pagination");
        })
        .on("click", ".groups.aui-nav-pagination a", function () {
            UserManagement.helpers.triggerAnalytics("group.pagination");
        })
        .on("submit", "#signup-domains-form", function () {
            UserManagement.helpers.triggerAnalytics("signup.submit", {
                enabled: $("#signupEnabled").prop("checked"),
                restrictions: $("#signupMode-public").prop("checked") ? 0 : $("#domains-signup").auiSelect2("val").length,
                notify: $("#notifyAdmin").prop("checked")
            });
        })
        .on("submit", "#user-signup", function () {
            UserManagement.helpers.triggerAnalytics("user.signup.submit");
        })
        .ajaxSuccess(function (e, xhr, options) {
            if (options.url.indexOf(AJS.contextPath() + "/rest/um/1/signup?token=") === 0) {
                UserManagement.helpers.triggerAnalytics("user.signup.valid");
            }
        })
        .ajaxError(function (e, xhr, options) {
            if (options.url.indexOf(AJS.contextPath() + "/rest/um/1/signup?token=") === 0) {
                UserManagement.helpers.triggerAnalytics("user.signup.invalid");
            }
        })
        .on("change", ".view-user-applications [name='applications']", function () {
            UserManagement.helpers.triggerAnalytics("user.applicationToggle", {
                userActive: !$('#user-name-title').hasClass('disabled-text')
            });

            if (!$(".view-user-applications [name='applications']").is(":checked")) {
                UserManagement.helpers.triggerAnalytics("user.applicationToggle.allUnchecked", {
                    diff: moment().diff($("#time-last-active").attr("datetime"))
                });
            }
        })
        .on("click", "#password-help-dialog", function () {
            UserManagement.helpers.triggerAnalytics("passwordpolicy.score.help");
        })
        .on("click", "#change-user-active-button", function (event) {
            var button = $(event.target);
            if (button.data('user-state')) {
                UserManagement.helpers.triggerAnalytics("user.detail.view.deactivate", {
                    diff: moment().diff($("#time-last-active").attr("datetime"))
                });
            } else {
                UserManagement.helpers.triggerAnalytics("user.detail.view.activate", {
                    diff: moment().diff($("#time-last-active").attr("datetime"))
                });
            }
        })
        .on("click", ".activationButton", function (event) {
            var button = $(event.target);
            if (button.data('active')) {
                UserManagement.helpers.triggerAnalytics("user.list.view.deactivate", {
                    diff: moment().diff($(event.target).parents('tr').find('time').attr('datetime'))
                });
            } else {
                UserManagement.helpers.triggerAnalytics("user.list.view.activate", {
                    diff: moment().diff($(event.target).parents('tr').find('time').attr('datetime'))
                });
            }
        })
        .on("click", "#application-access-config", function() {
            UserManagement.helpers.triggerAnalytics("app.config.configure");
        })
        .on("click", ".configure-in-product", function(event) {
            var $button = $(event.target);
            var productId = $button.closest('tbody').data('product-id');
            UserManagement.helpers.triggerAnalytics("app.config.configureinproduct", {
                product: productId
            });
        });
})(AJS.$);
