AJS.namespace('UserManagement.controllers.validators.NumberRangeValidator', window, {

    /**
     * Returns true iff value is an int between the two bounds (inclusive)
     * @param {Number} value - the value to check against
     * @param {Number} lowerBound - the lower bound, will error if fields value < this
     * @param {Number} upperBound - the upper bound, will error if fields value > this
     */
    validateInt: function(value, lowerBound, upperBound) {
        return !(Number(value) !== parseInt(value) || value < lowerBound || value > upperBound)
    },

    /**
     * Note - this function allows blank values.
     * @param {String} fieldName - the name of the field to validate and apply any errors to
     * @param {String} errorMessage - If there is an error, which message to display (note, not I18n key)
     * @param {Number} lowerBound - the lower bound, will error if fields value < this
     * @param {Number} upperBound - the upper bound, will error if fields value > this
     * @param {String} activateIfChecked - the id of a checkbox that, if not checked, will not validate the number
     */
    create: function(fieldName, errorMessage, lowerBound, upperBound, activateIfChecked) {
        return function(validation, fields){
            var value = fields[fieldName];
            if (AJS.$(activateIfChecked).prop('checked') && !UserManagement.controllers.validators.NumberRangeValidator.validateInt(value, lowerBound, upperBound)) {
               validation.addFieldError(fieldName, errorMessage);
            }
        }
    }

});