(function ($, root) {

    var ApplicationCheckboxController = {};


    /**
     * Adds relevant state information to product checkboxes, and binds an event to update other sub-products on checkbox
     * change. For use with application checkboxes that do not auto refresh (for example, invite user)
     *
     * @param licenceUsage licence information, required to find the hostProduct relationships
     * @param context The selector to look for 'input.checkbox' inside of.
     * @param [skipLicenceDisabledCheck] whether or not to look at the licence count to determine if products should start disabled
     */
    ApplicationCheckboxController.configureApplicationCheckboxRelationships = function(licenceUsage, context, skipLicenceDisabledCheck) {
        var lastSubproductUnchecked = function(currentProduct, changedProduct, productList) {
            var hasSubProductChecked = false;
            var subProductHasChanged = false;

            for(var i = 0; i < productList.length; i++) {
                var product = productList[i];
                if (product.platformProductName === currentProduct.name) {
                    var checkbox = $(selector + '[value="' + product.id + '"]');

                    hasSubProductChecked = hasSubProductChecked || checkbox.prop('checked');
                    subProductHasChanged = subProductHasChanged || product.id === changedProduct;
                }
            }
            return !hasSubProductChecked && subProductHasChanged;
        };

        var selector = context + ' input.checkbox';

        $(selector).on('change', function (e) {
            var changedCheckbox = $(e.target);
            changedCheckbox.parent().attr('isServerChecked', changedCheckbox.prop('checked'));

            var productList = $.map(licenceUsage.products, function (app) {
                var checkbox = $(selector + '[value="' + app.id + '"]');
                var hasLastSubproductUnchecked = lastSubproductUnchecked(app, changedCheckbox.prop('value'), licenceUsage.products);
                var isChangedCheckbox = app.id === changedCheckbox.prop('value');
                var shouldUseHiddenValue = hasLastSubproductUnchecked || isChangedCheckbox;

                return {
                    name: app.name,
                    type: app.description,
                    id: app.id,
                    value: app.id,
                    labelText: app.labelText,
                    isChecked: shouldUseHiddenValue ? checkbox.parent().attr('isServerChecked') === "true" : checkbox.prop('checked'),
                    isDisabled: !skipLicenceDisabledCheck && !(app.seatsAvailable === undefined) && app.seatsAvailable < 1,
                    platformProductName: app.platformProductName
                };
            });

            var newList = root.ApplicationCheckboxController.updatePlatformProductRelationship(productList);
            for (var i = 0; i < newList.length; i++) {
                var app = newList[i];
                var checkbox = $(selector + '[value="' + app.id + '"]');
                checkbox.prop('checked', app.isChecked);
                checkbox.prop('disabled', app.isDisabled);
            }
        });
    };

    /**
     * Updates the checkboxes for products based on any sub-product relationships.
     *
     * @param productList The list of product checkboxes
     * @returns {Array|*} An updated list of product checkboxes
     */
    ApplicationCheckboxController.updatePlatformProductRelationship = function(productList) {
        var hasSubProductChecked = function(currentProduct, productList) {
            for(var i = 0; i < productList.length; i++) {
                var product = productList[i];
                if (product.platformProductName === currentProduct.name && product.isChecked)
                {
                    return true;
                }
            }
            return false;
        };

        return $.map(productList, function (app) {
            var hasCheckedSubProduct = hasSubProductChecked(app, productList);

            app.isChecked = app.isChecked || hasCheckedSubProduct;
            app.isDisabled = app.isDisabled || hasCheckedSubProduct;
            return app;
        });
    };

    root.ApplicationCheckboxController = ApplicationCheckboxController;

})(AJS.$, window.UserManagement = window.UserManagement || {});
