(function($, adminApp){
    /**
     * Exposes the adminApp api. This api is used by other components of global admin to register with
     * the app framework and into various UI components. (ex. sidebar)
     */

    var sidebarNav = [];
    var adminAppPrivate = {
        //navigation functions
        addNavigationEntry: function(appId, navigationEntry) {
            navigationEntry.appId = appId;
            sidebarNav.push(navigationEntry);
        },

        updateNavigation: function(appId, navigationEntry){
            var newDom;
            for (var iterator = 0; iterator < sidebarNav.length; iterator++) {
                if (sidebarNav[iterator].appId === appId) {
                    //update the sidebarNav array just so it's complete and accurate
                    navigationEntry.appId = appId;
                    navigationEntry.dom = sidebarNav[iterator].dom;
                    sidebarNav[iterator] = navigationEntry;
                    //update the drawn sidebar if necessary
                    if (navigationEntry.dom) {
                        adminAppPrivate.generateNavigationEntryLinks(navigationEntry);
                        newDom = usermanagement.sidebar.block(navigationEntry);
                        navigationEntry.dom.replaceWith(newDom);
                        navigationEntry.dom = newDom;
                        Doppelganger.getFilterHandler('SidebarFilter').highlightActiveNavElement();
                    }
                }
            }
        },

        //Takes a navigationEntry and fills in any missing url fields.
        generateNavigationEntryLinks: function(navigationEntry){
            $.each(navigationEntry.links, function(index, link){
                if (!link.url) {
                    link.url = adminApp.app.routeManager.generate(link.route, {type: link.type});
                }
            });
        },

        drawNavigation: function(){
            AJS.$.each(sidebarNav, function(index, navigationEntry){
                adminAppPrivate.generateNavigationEntryLinks(navigationEntry);
                //Create the sidebarBlock, store it for later updates and appendTo the menu.
                navigationEntry.dom = $(usermanagement.sidebar.block(navigationEntry))
                    .appendTo('#admin-menu > .aui-page-panel-inner');
            });
        },

        enableSinglePageLinks: function() {
            $(document).on('click', 'a', function (e) {
                if (!(e.metaKey || e.ctrlKey || e.shiftKey)) {
                    var href = $(e.target).attr('href');
                    if (href) {
                        var page = adminApp.app.routeManager.recognize($(e.target).attr('href'));
                        if (page) {
                            e.preventDefault();
                            adminApp.app.navigate(page.destination, page.params)
                        }
                    }
                }
            }).on('click', 'a, button', function (e) {
                var $target = $(e.target);
                var analyticsEvent = $target.data('analyticsEvent');
                if (analyticsEvent) {
                    var analyticsData = $target.data('analyticsData');
                    adminApp.triggerAnalytics(analyticsEvent, analyticsData);
                }
            });
        }
    };

    var servletPath = AJS.umServletPath ? AJS.umServletPath() : "/plugins/servlet/um";

    $.extend(adminApp, {
        init: function() {
            if (!this.isFeatureEnabled('uac.single.page.links.kill')) {
                adminAppPrivate.enableSinglePageLinks();
            }

            this.app = Doppelganger.create({
                rootUrl: AJS.contextPath() + servletPath + "/",
                routes: this.routeList,
                filters: this.filterList,
                defaultRoute: ['list', { type: 'users' }],
                urlCoerceMode: false
            });
            this.app.init();
        },

        addApplication: function(appId, options) {
            var routes = options.routes;
            var routesLength = routes.length;
            var i = 0;
            var current;
            for (; i < routesLength; i++) {
                current = routes[i];
                Doppelganger.setRouteHandler(current.name, current.handler);
                adminApp.routeList.push(current);
            }
            if (options.navigation) {
                adminAppPrivate.addNavigationEntry(appId, options.navigation);
            }
            if (options.titleMap) {
                $.extend(adminApp.titleMap, options.titleMap);
            }
        },

        //Could support updating all 'app' things but for now it only supports the navigation
        updateApplication: function(appId, options) {
            if (options.navigation) {
                adminAppPrivate.updateNavigation(appId, options.navigation);
            }
        },

        navigationCallbacks: [],
        drawNavigation: function(){
            adminAppPrivate.drawNavigation();
            $.each(adminApp.navigationCallbacks, function(i, callback){
                callback();
            })
        },

        navigationDrawn: function(callback){
            adminApp.navigationCallbacks.push(callback);
        },

        triggerAnalytics: function(name, properties) {
            AJS.trigger("analytics", {
                name: 'unified.admin.' + name,
                data: properties || {}
            });
        },

        isFeatureEnabled: (function(){
            //Avoid doing a dom lookup every time this function is run. The meta tag comes before scripts so no need for domready.
            var darkFeatures = AJS.$('meta[name="enabled-dark-features"]').data('content');
            return function (key) {
                return darkFeatures && darkFeatures.indexOf(key) !== -1;
            }
        })(),

        routeList: [],
        filterList: ['ApdexFilter', 'RouterFilter', 'SidebarFilter', 'EventFilter', 'FocusedTaskFilter', 'CrowdFilter', 'TitleFilter'],
        titleMap: {}
    });
})(AJS.$, window.adminApp = window.adminApp || {});
