/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.util.license.DefaultLicense;
import com.atlassian.util.license.License;
import com.atlassian.util.license.LicenseChangeListener;
import com.atlassian.util.license.LicenseChangedEvent;
import com.atlassian.util.license.LicenseFileParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseFileListener
implements FileListener {
    private static final Logger log = LoggerFactory.getLogger(LicenseFileListener.class);
    public static final String LICENSE_FILE = "studio.license";
    private LicenseChangeListener licenseChangeListener;
    private final LicenseFileParser licenseFileParser;

    public LicenseFileListener(LicenseFileParser licenseFileParser) {
        this.licenseFileParser = licenseFileParser;
    }

    public synchronized void setListener(LicenseChangeListener listener) {
        this.licenseChangeListener = listener;
    }

    @Override
    public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            log.info("{} was created.", (Object)fileChangeEvent.getFile().getName());
            this.readAndNotifyFromEvent(fileChangeEvent);
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            FileName fileName = fileChangeEvent.getFile().getName();
            log.error("{} was deleted. Existing license will be cached until restart or a new license appears.", (Object)fileName);
        }
    }

    @Override
    public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            log.info("{} was modified.", (Object)fileChangeEvent.getFile().getName());
            this.readAndNotifyFromEvent(fileChangeEvent);
        }
    }

    private static boolean isLicenseFile(FileChangeEvent fileChangeEvent) {
        return fileChangeEvent.getFile().getName().getBaseName().equals(LICENSE_FILE);
    }

    @VisibleForTesting
    synchronized void readAndNotify(InputStream inputStream) {
        Optional<DefaultLicense> potentialLicense = this.licenseFileParser.parseLicenseFile(inputStream);
        if (potentialLicense.isPresent()) {
            Preconditions.checkState((this.licenseChangeListener != null ? 1 : 0) != 0, (Object)"Need to set Listener before setting up file system changes");
            this.licenseChangeListener.onUpdate(new LicenseChangedEvent((License)potentialLicense.get()));
        }
    }

    private void readAndNotifyFromEvent(FileChangeEvent fileChangeEvent) throws FileSystemException {
        this.readAndNotify(fileChangeEvent.getFile().getContent().getInputStream());
    }

    public void readAndNotifyFromFile(File licenseFile) {
        try {
            this.readAndNotify(new FileInputStream(licenseFile));
        }
        catch (FileNotFoundException e) {
            log.error("Important, we could not read the license file: {}", (Object)licenseFile.getAbsolutePath(), (Object)e);
        }
    }
}

