/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.util.license.License;
import com.atlassian.util.license.LicenseableApplication;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

public class DefaultLicense
implements License {
    static final String SEN_KEY = "SEN";
    static final String EXTERNAL_UUID_KEY = "externalUuid";
    static final String ACTIVE_SUFFIX = ".active";
    static final String ACTIVE_STATUS = "true";
    private final Properties licenseProperties;

    public DefaultLicense(Properties licenseProperties) {
        this.licenseProperties = licenseProperties;
    }

    @Override
    public boolean isProductLicensed(String productNamespace) {
        return ACTIVE_STATUS.equals(this.licenseProperties.getProperty(productNamespace + ACTIVE_SUFFIX));
    }

    public Set<String> getAllLicensedNamespaces() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String property : this.licenseProperties.stringPropertyNames()) {
            if (!property.endsWith(ACTIVE_SUFFIX) || !ACTIVE_STATUS.equals(this.licenseProperties.getProperty(property))) continue;
            builder.add((Object)property.substring(0, property.length() - ACTIVE_SUFFIX.length()));
        }
        return builder.build();
    }

    @Override
    public Set<LicenseableApplication> getLicensedApps() {
        return ImmutableSet.copyOf((Collection)Sets.filter(EnumSet.allOf(LicenseableApplication.class), (Predicate)new Predicate<LicenseableApplication>(){

            public boolean apply(LicenseableApplication app) {
                return DefaultLicense.this.isProductLicensed(app.getNamespace());
            }
        }));
    }

    @Override
    public Optional<String> getSEN() {
        return Optional.fromNullable((Object)this.licenseProperties.getProperty(SEN_KEY));
    }

    @Override
    public Optional<String> getExternalUUID() {
        return Optional.fromNullable((Object)this.licenseProperties.getProperty(EXTERNAL_UUID_KEY));
    }
}

