/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity.host;

import com.atlassian.fugue.Iterables;
import com.atlassian.usermanagement.client.entity.host.HostAdminEntity;
import com.atlassian.usermanagement.client.entity.host.HostDescriptionEntity;
import com.atlassian.usermanagement.client.entity.host.HostLicensingEntity;
import com.atlassian.usermanagement.client.entity.host.HostProductEntity;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

public class HostEntity {
    @JsonProperty
    private final HostDescriptionEntity description;
    @JsonProperty
    private final HostAdminEntity administration;
    @JsonProperty
    private final HostLicensingEntity licensing;
    @JsonProperty
    private final Set<HostProductEntity> products;

    @JsonCreator
    public HostEntity(@JsonProperty(value="description") HostDescriptionEntity description, @JsonProperty(value="administration") HostAdminEntity administration, @JsonProperty(value="licensing") HostLicensingEntity licensing, @JsonProperty(value="products") Set<HostProductEntity> products) {
        this.description = description;
        this.administration = administration;
        this.licensing = licensing;
        this.products = products;
    }

    public HostDescriptionEntity getDescription() {
        return this.description;
    }

    public HostAdminEntity getAdministration() {
        return this.administration;
    }

    public HostLicensingEntity getLicensing() {
        return this.licensing;
    }

    public Set<HostProductEntity> getProducts() {
        return this.products;
    }

    @JsonIgnore
    @Nullable
    public HostProductEntity getProduct(String productId) {
        for (HostProductEntity product : this.products) {
            if (!product.getProductKey().equals(productId)) continue;
            return product;
        }
        return null;
    }

    @JsonIgnore
    public Set<String> getProductKeys() {
        HashSet<String> productIds = new HashSet<String>();
        for (HostProductEntity product : this.getProducts()) {
            productIds.add(product.getProductKey());
        }
        return productIds;
    }

    public String toString() {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return "Unable to print entity: " + e.toString();
        }
    }

    public HostProductEntity findPlatformProduct() {
        if (this.getProducts().size() == 1) {
            Iterables.first(this.getProducts()).get();
        }
        for (HostProductEntity productEntity : this.getProducts()) {
            if (!productEntity.isPlatform()) continue;
            return productEntity;
        }
        throw new RuntimeException("All hosts must contain a platform product");
    }
}

