/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity;

import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ConfigurationEntity {
    @JsonProperty
    private final String productId;
    @JsonProperty
    private final String productDisplayName;
    @JsonProperty
    private final Set<AccessLevel> canLogin;
    @JsonProperty
    private final LicenseInformationEntity licenseInformation;
    @JsonProperty
    private final Map<AccessLevel, PermissionEntity> permissions;
    @JsonProperty
    private final String permissionsPath;
    @JsonProperty
    private final int weight;

    @JsonCreator
    public ConfigurationEntity(@JsonProperty(value="productId") String productId, @JsonProperty(value="productDisplayName") String productDisplayName, @JsonProperty(value="canLogin") Set<AccessLevel> canLogin, @JsonProperty(value="licenseInformation") LicenseInformationEntity licenseInformation, @JsonProperty(value="permissions") Map<AccessLevel, PermissionEntity> permissions, @JsonProperty(value="permissionsPath") String permissionsPath, @JsonProperty(value="weight") int weight) {
        this.productId = productId;
        this.productDisplayName = productDisplayName;
        this.canLogin = ConfigurationEntity.validateCanLogin(canLogin);
        this.licenseInformation = licenseInformation;
        this.permissions = permissions;
        this.permissionsPath = permissionsPath;
        this.weight = weight;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductDisplayName() {
        return this.productDisplayName;
    }

    public Set<AccessLevel> getCanLogin() {
        return this.canLogin;
    }

    public LicenseInformationEntity getLicenseInformation() {
        return this.licenseInformation;
    }

    public Map<AccessLevel, PermissionEntity> getPermissions() {
        return this.permissions;
    }

    public String getPermissionsPath() {
        return this.permissionsPath;
    }

    public int getWeight() {
        return this.weight;
    }

    private static Set<AccessLevel> validateCanLogin(Collection<AccessLevel> includedAccessLevels) {
        ImmutableSet included = ImmutableSet.copyOf((Collection)Collections2.filter((Collection)((Collection)Preconditions.checkNotNull(includedAccessLevels, (Object)"canLogin must not be null.")), (Predicate)Predicates.notNull()));
        Preconditions.checkArgument((!included.isEmpty() ? 1 : 0) != 0, (Object)"canLogin must not be empty.");
        return included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationEntity that = (ConfigurationEntity)o;
        if (this.weight != that.weight) {
            return false;
        }
        if (!this.canLogin.equals(that.canLogin)) {
            return false;
        }
        if (!this.licenseInformation.equals(that.licenseInformation)) {
            return false;
        }
        if (!this.permissions.equals(that.permissions)) {
            return false;
        }
        if (!this.permissionsPath.equals(that.permissionsPath)) {
            return false;
        }
        if (!this.productDisplayName.equals(that.productDisplayName)) {
            return false;
        }
        return this.productId.equals(that.productId);
    }

    public int hashCode() {
        int result = this.productId.hashCode();
        result = 31 * result + this.productDisplayName.hashCode();
        result = 31 * result + this.canLogin.hashCode();
        result = 31 * result + this.licenseInformation.hashCode();
        result = 31 * result + this.permissions.hashCode();
        result = 31 * result + this.permissionsPath.hashCode();
        result = 31 * result + this.weight;
        return result;
    }
}

