/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client;

import com.atlassian.fugue.Iterables;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public enum AccessLevel {
    NONE,
    USE,
    ADMIN,
    SYSADMIN;

    private static final List<AccessLevel> ranking;

    public static AccessLevel findHighest(Collection<AccessLevel> accessLevels) {
        return Iterables.findFirst(ranking, Predicates.in(accessLevels)).getOrElse(NONE);
    }

    public static Collection<AccessLevel> rangeFromHighToLow(AccessLevel fromInclusive, AccessLevel toExclusive) {
        final int from = ((AccessLevel)((Object)Preconditions.checkNotNull((Object)((Object)fromInclusive)))).ordinal();
        final int to = ((AccessLevel)((Object)Preconditions.checkNotNull((Object)((Object)toExclusive)))).ordinal();
        return Collections2.filter(ranking, (Predicate)new Predicate<AccessLevel>(){

            public boolean apply(@Nullable AccessLevel input) {
                return input != null && input.ordinal() <= from && input.ordinal() > to;
            }
        });
    }

    static {
        ranking = ImmutableList.of((Object)((Object)SYSADMIN), (Object)((Object)ADMIN), (Object)((Object)USE), (Object)((Object)NONE));
    }
}

