/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import java.util.HashSet;

public class UserTemplateBuilder {
    private final UserTemplateWithAttributes userTemplate;

    public UserTemplateBuilder(UserTemplateWithAttributes userTemplate) {
        this.userTemplate = userTemplate;
    }

    public static UserTemplateBuilder withName(String name) {
        return new UserTemplateBuilder(new UserTemplateWithAttributes(name, -1L));
    }

    public static UserTemplateBuilder from(UserEntity userEntity) {
        UserTemplateWithAttributes userTemplate = new UserTemplateWithAttributes(userEntity.getName(), -1L);
        if (userEntity.isActive() != null) {
            userTemplate.setActive(userEntity.isActive().booleanValue());
        }
        if (userEntity.getDirectoryId() != null) {
            userTemplate.setDirectoryId(userEntity.getDirectoryId().longValue());
        }
        if (userEntity.getDisplayName() != null) {
            userTemplate.setDisplayName(userEntity.getDisplayName());
        }
        if (userEntity.getEmail() != null) {
            userTemplate.setEmailAddress(userEntity.getEmail());
        }
        if (userEntity.getFirstName() != null) {
            userTemplate.setFirstName(userEntity.getFirstName());
        }
        if (userEntity.getLastName() != null) {
            userTemplate.setLastName(userEntity.getLastName());
        }
        if (userEntity.getAttributes() != null) {
            for (MultiValuedAttributeEntity attributeEntity : userEntity.getAttributes()) {
                userTemplate.setAttribute(attributeEntity.getName(), new HashSet<String>(attributeEntity.getValues()));
            }
        }
        return new UserTemplateBuilder(userTemplate);
    }

    public UserTemplateBuilder withActive(boolean active) {
        this.userTemplate.setActive(active);
        return this;
    }

    public UserTemplateBuilder withDirectoryId(long directoryId) {
        this.userTemplate.setDirectoryId(directoryId);
        return this;
    }

    public UserTemplateBuilder withEmailAddress(String emailAddress) {
        this.userTemplate.setEmailAddress(emailAddress);
        return this;
    }

    public UserTemplateBuilder withFirstName(String firstName) {
        this.userTemplate.setFirstName(firstName);
        return this;
    }

    public UserTemplateBuilder withLastName(String lastName) {
        this.userTemplate.setLastName(lastName);
        return this;
    }

    public UserTemplateBuilder withDisplayName(String displayName) {
        this.userTemplate.setDisplayName(displayName);
        return this;
    }

    public UserTemplateWithAttributes build() {
        return this.userTemplate;
    }
}

