/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;

public class StringFunctions {
    public static final Function<String, String> HTML_ESCAPER = new Function<String, String>(){

        public String apply(@Nullable String input) {
            return StringEscapeUtils.escapeHtml4(input);
        }
    };
    public static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        public String apply(String emailAddress) {
            return emailAddress.toLowerCase();
        }
    };

    public static Function<String, String> htmlEscaper() {
        return HTML_ESCAPER;
    }

    public static Function<String, String> prefixer(final String prefix) {
        return new Function<String, String>(){

            public String apply(String input) {
                return prefix + input;
            }
        };
    }

    public static Function<String, String> suffixer(final String suffix) {
        return new Function<String, String>(){

            public String apply(String input) {
                return input + suffix;
            }
        };
    }

    public static Function<String, String> infixer(String prefix, String suffix) {
        return Functions.compose(StringFunctions.suffixer(suffix), StringFunctions.prefixer(prefix));
    }

    public static Function<String, String> toLowerCase() {
        return TO_LOWER_CASE;
    }

    private StringFunctions() {
        throw new UnsupportedOperationException();
    }
}

