/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.service.GrantProductAccessResult;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Functions;
import com.atlassian.usermanagement.client.util.ImmutableMapUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FailureUtils {
    private FailureUtils() {
        throw new UnsupportedOperationException();
    }

    public static <R> Map<Product, R> handleMaybeFailures(Map<Product, Either<Failure, R>> result) throws LicenseExceededException {
        ImmutableMap failures = ImmutableMapUtils.collectByValue(result, Eithers.leftMapper());
        FailureUtils.handleFailures(failures);
        return ImmutableMapUtils.collectByValue(result, Eithers.rightMapper());
    }

    public static <R> R handleMaybeFailures(Either<Map<Product, Failure>, R> result) throws LicenseExceededException {
        if (result.isLeft()) {
            FailureUtils.handleFailures((Map)result.left().get());
        }
        return result.right().get();
    }

    public static void handleFailures(Map<Product, Failure> failures) throws LicenseExceededException {
        if (failures.size() > 0) {
            ImmutableMap<Product, ProductAccessError> accessErrors = ImmutableMapUtils.collectByValue(failures, Functions.isInstanceOf(ProductAccessError.class));
            if (accessErrors.size() > 0) {
                throw new ProductAccessErrorException((Map<Product, ProductAccessError>)accessErrors);
            }
            ImmutableMap<Product, LicenseExceeded> licenseErrors = ImmutableMapUtils.collectByValue(failures, Functions.isInstanceOf(LicenseExceeded.class));
            if (licenseErrors.size() > 0) {
                throw new LicenseExceededException((Map<Product, LicenseExceeded>)licenseErrors);
            }
            throw new RuntimeException("There are unhandled failures beside ApplicationAccessError and LicenseExceeded: " + failures);
        }
    }

    public static Map<Product, Either<Failure, GrantProductAccessResult>> mapResultsToEffectiveProducts(List<Product> allProducts, Set<Product> requiredProducts, Set<String> usernames, Set<String> groups, Map<String, BulkAddResult<String>> addUsersToGroupsResults) {
        Sets.SetView effectiveProducts = Sets.union(requiredProducts, ProductUtils.getAvailableProductsAccessibleViaGroups(allProducts, groups));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Product product : effectiveProducts) {
            if (product.hasConfig()) {
                ProductConfig config = (ProductConfig)product.getConfig().right().get();
                ImmutableSet commonFailures = null;
                for (String loginGroup : config.getCanLoginGroups()) {
                    if (!addUsersToGroupsResults.containsKey(loginGroup)) continue;
                    ImmutableSet groupFailures = ImmutableSet.copyOf((Collection)addUsersToGroupsResults.get(loginGroup).getFailedEntities());
                    commonFailures = commonFailures == null ? ImmutableSet.copyOf((Collection)groupFailures) : Sets.intersection(commonFailures, (Set)groupFailures);
                }
                builder.put((Object)product, Either.right(new GrantProductAccessResult((Set<String>)Sets.difference(usernames, commonFailures), (Set<String>)commonFailures)));
                continue;
            }
            builder.put((Object)product, Either.left(product.getConfig().left().get()));
        }
        return builder.build();
    }
}

