/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;

public class LicenseCheckSeatsFunction
implements Function<Product, Option<LicenseExceeded>> {
    private final UserProvisioningService userProvisioningService;
    private final int requiredSeats;

    public LicenseCheckSeatsFunction(UserProvisioningService userProvisioningService, int requiredSeats) {
        this.userProvisioningService = userProvisioningService;
        this.requiredSeats = requiredSeats;
    }

    public Option<LicenseExceeded> apply(Product product) {
        if (!product.hasConfig()) {
            return Option.none();
        }
        Option<Integer> potentialSeatsAvailable = this.getSeatsAvailable(product);
        if (potentialSeatsAvailable.isEmpty()) {
            return Option.none();
        }
        if (this.requiredSeats > Math.max((Integer)potentialSeatsAvailable.get(), 0)) {
            return Option.some(new LicenseExceeded(this.requiredSeats, (Integer)potentialSeatsAvailable.get()));
        }
        return Option.none();
    }

    private Option<Integer> getSeatsAvailable(Product product) {
        try {
            return this.userProvisioningService.getAvailableSeatsForProduct(product);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return Option.none();
        }
    }
}

