/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseCheckFunction;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.QueryUtils;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.usermanagement.client.AccessLevel;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

public class LicenseCheckFunctionGrantAccessToGroups
extends LicenseCheckFunction<LicenseExceeded> {
    private final DirectoryLocator directoryLocator;
    private final DirectoryManager directoryManager;
    private final Set<String> groups;
    private final AccessLevel accessLevel;

    public LicenseCheckFunctionGrantAccessToGroups(DirectoryLocator directoryLocator, DirectoryManager directoryManager, Set<String> groups, UserProvisioningService userProvisioningService, AccessLevel accessLevel) {
        super(userProvisioningService, false);
        this.directoryLocator = directoryLocator;
        this.directoryManager = directoryManager;
        this.groups = groups;
        this.accessLevel = accessLevel;
    }

    @Override
    protected Option<LicenseExceeded> buildError(Product product, Set<String> usersGainingAccess, int seatsRequired, int seatsAvailable) {
        return Option.some(new LicenseExceeded(seatsRequired, seatsAvailable));
    }

    @Override
    protected Set<String> getUsersPotentiallyGainingLicenseSeat(Product product) {
        if (this.userProvisioningService.getAllLoginGroups(product).containsAll(this.groups)) {
            return ImmutableSet.of();
        }
        Either<ProductAccessError, ProductConfig> maybeConfig = product.getConfig();
        if (maybeConfig.isLeft()) {
            return ImmutableSet.of();
        }
        if (!((ProductConfig)maybeConfig.right().get()).getCanLoginLevels().contains((Object)this.accessLevel)) {
            return ImmutableSet.of();
        }
        HashSet<String> membersOfGroups = new HashSet<String>();
        for (String group : this.groups) {
            MembershipQuery<String> membershipQuery = QueryUtils.getMembersOfGroupQuery(group, 0, -1);
            try {
                membersOfGroups.addAll(this.directoryManager.searchDirectGroupRelationships(this.directoryLocator.getDirectoryId(), membershipQuery));
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
        return membersOfGroups;
    }
}

