/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class LicenceExceedOnActivationPredicateFactory {
    private final UserProvisioningService userProvisioningService;
    private final String userName;
    private final Set<String> userGroups;

    public LicenceExceedOnActivationPredicateFactory(UserProvisioningService userProvisioningService, String userName, List<String> userGroups) {
        this.userProvisioningService = userProvisioningService;
        this.userName = userName;
        this.userGroups = Sets.newHashSet(userGroups);
    }

    public Predicate<Product> buildActivationLicenceCheckPredicate() {
        return new Predicate<Product>(){

            public boolean apply(Product product) {
                if (product.getConfig().isLeft()) {
                    return false;
                }
                if (LicenceExceedOnActivationPredicateFactory.this.getSeatsAvailable(product) <= 0) {
                    Set<String> loginGroups = LicenceExceedOnActivationPredicateFactory.this.userProvisioningService.getAllLoginGroups(product);
                    Set<String> usersWithDirectAccess = LicenceExceedOnActivationPredicateFactory.this.userProvisioningService.getAllLoginUsers(product);
                    if (usersWithDirectAccess.contains(LicenceExceedOnActivationPredicateFactory.this.userName) || !Sets.intersection(loginGroups, (Set)LicenceExceedOnActivationPredicateFactory.this.userGroups).isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private Integer getSeatsAvailable(Product product) {
        try {
            return this.userProvisioningService.getAvailableSeatsForProduct(product).getOrElse(Integer.MAX_VALUE);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

