/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.ProductComparator;
import com.atlassian.fugue.Either;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.GroupAttributesEntity;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.atlassian.usermanagement.client.entity.host.HostEntity;
import com.atlassian.usermanagement.client.entity.host.HostProductEntity;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class HostedProduct
implements Product {
    private static final Comparator<Product> PRODUCT_COMPARATOR = new ProductComparator();
    private final ProductId productId;
    private final String hostId;
    private final String productKey;
    private final HostEntity hostEntity;
    private final HostProductEntity productEntity;
    private final Map<AccessLevel, PermissionEntity> permissions;

    public HostedProduct(String hostId, HostEntity hostEntity, String productKey, Map<AccessLevel, PermissionEntity> permissions) {
        this.hostId = hostId;
        this.productKey = productKey;
        this.productId = ProductId.fromHostIdAndProductKey(hostId, productKey);
        this.hostEntity = hostEntity;
        this.permissions = permissions;
        this.productEntity = hostEntity.getProduct(productKey);
    }

    @Override
    public ProductEntity getProductEntity(I18nResolver i18nResolver) {
        HostProductEntity product = this.hostEntity.getProduct(this.productKey);
        return new ProductEntity(this.getProductId().toString(), product.getName(), product.getName(), null);
    }

    @Override
    public String getProductKey() {
        return this.productKey;
    }

    @Override
    public ProductId getProductId() {
        return this.productId;
    }

    @Override
    public String getProductName() {
        return this.hostEntity.getProduct(this.productKey).getName();
    }

    @Override
    public String getHostId() {
        return this.hostEntity.getDescription().getHostId();
    }

    @Override
    public String getHostType() {
        return this.hostEntity.getDescription().getType();
    }

    @Override
    public String getPermissionsUrl() {
        return this.hostEntity.getDescription().getDisplayURI().toString() + this.productEntity.getPermissionsPath();
    }

    @Override
    public void revokeUser(String username, AccessLevel accessLevel) throws CredentialsRequiredException, ResponseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasConfig() {
        return true;
    }

    @Override
    public boolean isPlatform() {
        return this.productEntity != null && this.productEntity.isPlatform();
    }

    @Override
    public int getWeight() {
        return this.productEntity.getWeight();
    }

    @Override
    public Either<ProductAccessError, ProductConfig> getConfig() {
        return Either.right(new Config());
    }

    @Override
    public int compareTo(Product o) {
        return PRODUCT_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostedProduct that = (HostedProduct)o;
        if (this.productId != null ? !this.productId.equals(that.productId) : that.productId != null) {
            return false;
        }
        if (this.hostEntity != null ? !this.hostEntity.equals(that.hostEntity) : that.hostEntity != null) {
            return false;
        }
        return !(this.productKey != null ? !this.productKey.equals(that.productKey) : that.productKey != null);
    }

    public int hashCode() {
        int result = this.productKey != null ? this.productKey.hashCode() : 0;
        result = 31 * result + (this.hostEntity != null ? this.hostEntity.hashCode() : 0);
        result = 31 * result + (this.productId != null ? this.productId.hashCode() : 0);
        return result;
    }

    public class Config
    implements ProductConfig {
        @Override
        public Map<AccessLevel, PermissionEntity> getPermissions() {
            return HostedProduct.this.permissions;
        }

        @Override
        public String getPermissionsUrl() {
            return HostedProduct.this.hostEntity.getDescription().getDisplayURI().toString() + HostedProduct.this.productEntity.getPermissionsPath();
        }

        @Override
        public PermissionEntity getPermissions(AccessLevel level) {
            return (PermissionEntity)HostedProduct.this.permissions.get((Object)level);
        }

        @Override
        public LicenseInformationEntity getLicense() {
            return new LicenseInformationEntity(HostedProduct.this.productEntity.getLicenseLimit(), this.getAccessLevelsExcludedFromCount(), this.getGroupsExcludedFromCount());
        }

        @Override
        public Set<AccessLevel> getAccessLevelsExcludedFromCount() {
            return HostedProduct.this.hostEntity.getLicensing().getExcludeLevels();
        }

        @Override
        public Set<String> getGroupsExcludedFromCount() {
            return HostedProduct.this.hostEntity.getLicensing().getExcludeGroups();
        }

        @Override
        public Set<AccessLevel> getCanLoginLevels() {
            return Sets.newHashSet((Object[])new AccessLevel[]{AccessLevel.USE});
        }

        @Override
        public Map<String, GroupAttributesEntity> getGroupPermissions(AccessLevel level) {
            return PermissionEntity.getGroupPermissions(this.getPermissions(), level);
        }

        @Override
        public Set<String> getGroups(AccessLevel level) {
            return PermissionEntity.getGroups(this.getPermissions(), level);
        }

        @Override
        public Set<String> getCanLoginGroups() {
            return ProductUtils.getGroupsForLevels(this.getCanLoginLevels(), this);
        }

        @Override
        public Set<String> getDefaultGroups(AccessLevel level) {
            return PermissionEntity.getDefaultGroups(HostedProduct.this.permissions, level);
        }

        @Override
        public Boolean isPlatformProduct() {
            return HostedProduct.this.hostEntity.findPlatformProduct().getProductKey().equals(HostedProduct.this.productKey);
        }

        @Override
        public String getPlatformProductName() {
            return HostedProduct.this.hostEntity.findPlatformProduct().getName();
        }

        @Override
        public ProductId getPlatformProductId() {
            return ProductId.fromHostIdAndProductKey(HostedProduct.this.hostId, HostedProduct.this.hostEntity.findPlatformProduct().getProductKey());
        }

        @Override
        public Boolean isConfigurable() {
            return true;
        }

        @Override
        public String getConfiguredProductName() {
            return HostedProduct.this.productEntity.getName();
        }
    }
}

