/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.passwordscore;

import com.atlassian.crowd.plugin.usermanagement.service.passwordscore.PasswordScoreResult;
import com.atlassian.crowd.plugin.usermanagement.service.passwordscore.ServiceUnavailableException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

class PasswordPolicyWebResource {
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 1000;
    private final WebResource webResource;

    public PasswordPolicyWebResource(String location) {
        this.webResource = PasswordPolicyWebResource.createClient().resource(location);
    }

    public boolean isServiceAvailable() {
        try {
            return ((ClientResponse)this.webResource.path("healthcheck").get(ClientResponse.class)).getStatus() == 200;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public PasswordScoreResult getPasswordScore(String password, List<String> userInfo) throws ServiceUnavailableException {
        try {
            MultivaluedMapImpl map = new MultivaluedMapImpl();
            map.putSingle((Object)"password", (Object)password);
            map.put((Object)"user_inputs", userInfo);
            return (PasswordScoreResult)this.webResource.path("/").type("application/x-www-form-urlencoded").post(PasswordScoreResult.class, (Object)map);
        }
        catch (RuntimeException e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static Client createClient() {
        Client client = Client.create((ClientConfig)PasswordPolicyWebResource.createClientConfig());
        client.setConnectTimeout(Integer.valueOf(1000));
        client.setReadTimeout(Integer.valueOf(1000));
        return client;
    }

    private static ClientConfig createClientConfig() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(JacksonJsonProvider.class);
        return config;
    }
}

