/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SeatsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MembershipChangeCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.GrantProductAccessResult;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.GrantingUseAccessSideEffect;
import com.atlassian.crowd.plugin.usermanagement.service.validation.IntertwinedConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseCheckFunctionAddUsersToGroups;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseCheckSeatsFunction;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.service.validation.RevokingUseAccessSideEffect;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.util.FailureUtils;
import com.atlassian.crowd.plugin.usermanagement.util.QueryUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserAndGroupCheckServiceFunctions;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.GroupAttributesEntity;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.atlassian.usermanagement.client.util.ImmutableMapUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserProvisioningServiceImpl
implements UserProvisioningService {
    private static final String DEFAULT_APP_PLUGIN_SETTINGS_KEY = "com.atlassian.crowd.plugin.usermanagement:default-apps:";
    private static final int DATABASE_BATCHING_SIZE = 50;
    private static final Logger log = LoggerFactory.getLogger(UserProvisioningServiceImpl.class);
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final DirectoryLocator directoryLocator;
    private final DirectoryManager directoryManager;
    private final PluginSettings pluginSettings;
    private final ProductService productService;
    private final Predicate<Product> IS_DEFAULT_PRODUCT = new Predicate<Product>(){

        public boolean apply(Product product) {
            return UserProvisioningServiceImpl.this.isDefaultProduct(product.getProductId());
        }
    };
    private final Function<Product, Boolean> TO_PRODUCT_DEFAULTS_ENTITY = new Function<Product, Boolean>(){

        public Boolean apply(Product product) {
            return UserProvisioningServiceImpl.this.isDefaultProduct(product.getProductId());
        }
    };

    UserProvisioningServiceImpl(UserAndGroupCheckService userAndGroupCheckService, DirectoryLocator directoryLocator, DirectoryManager directoryManager, PluginSettingsFactory pluginSettingsFactory, ProductService productService) {
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.directoryLocator = directoryLocator;
        this.directoryManager = directoryManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.productService = productService;
    }

    @Override
    public Map<Product, Either<Failure, GrantProductAccessResult>> grantProductAccess(List<Product> allProducts, Set<String> requiredUserNames, Set<Product> requiredProducts, boolean bypassInactiveUserChecks) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException, UserNotFoundException, GroupNotFoundException, MembershipChangeCausingLicenseException, ReadOnlyGroupException, DirectoryPermissionException, LicenseExceededException {
        return this.grantProductAccessInternal(allProducts, requiredUserNames, requiredProducts, bypassInactiveUserChecks, false);
    }

    @Override
    public Map<Product, Either<Failure, GrantProductAccessResult>> grantProductAccessAnonymously(List<Product> allProducts, Set<String> usernames, Set<Product> requiredProducts) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException, UserNotFoundException, GroupNotFoundException, MembershipChangeCausingLicenseException, ReadOnlyGroupException, DirectoryPermissionException, LicenseExceededException {
        return this.grantProductAccessInternal(allProducts, usernames, requiredProducts, false, true);
    }

    private Map<Product, Either<Failure, GrantProductAccessResult>> grantProductAccessInternal(List<Product> allProducts, Set<String> usernames, Set<Product> requiredProducts, boolean byPassInactiveUserChecks, boolean noUserInContext) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException, NoDefaultGroupException, LicenseExceededException {
        try {
            Set<String> requiredDefaultGroups = ProductUtils.getRequiredDefaultGroups(requiredProducts);
            Map<String, BulkAddResult<String>> addUsersToGroupsResults = this.addUsersToGroups(allProducts, usernames, requiredDefaultGroups, byPassInactiveUserChecks, noUserInContext);
            return FailureUtils.mapResultsToEffectiveProducts(allProducts, requiredProducts, usernames, requiredDefaultGroups, addUsersToGroupsResults);
        }
        catch (MembershipChangeCausingLicenseException e) {
            return Maps.transformValues(e.getInfo(), (Function)new Function<MembershipChangeCausingLicenseExceeded, Either<Failure, GrantProductAccessResult>>(){

                public Either<Failure, GrantProductAccessResult> apply(@Nullable MembershipChangeCausingLicenseExceeded input) {
                    return Either.left(input.getLicenseExceeded());
                }
            });
        }
    }

    @Override
    public UserProvisioningService.Reservation reserveProductAccess(List<Product> allProducts, int requiredSeats, Set<Product> requestedProducts) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, LicenseExceededException, OperationFailedException, NoDefaultGroupException, MembershipChangeCausingLicenseException {
        return this.reserveProductAccessInternal(allProducts, requiredSeats, requestedProducts, false);
    }

    @Override
    public UserProvisioningService.Reservation reserveProductAccessAnonymously(List<Product> allProducts, int requiredSeats, Set<Product> requestedProducts) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, LicenseExceededException, OperationFailedException, NoDefaultGroupException, MembershipChangeCausingLicenseException {
        return this.reserveProductAccessInternal(allProducts, requiredSeats, requestedProducts, true);
    }

    private UserProvisioningService.Reservation reserveProductAccessInternal(final List<Product> allProducts, final int requiredSeats, final Set<Product> requiredProducts, final boolean noUserInContext) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, LicenseExceededException, OperationFailedException, NoDefaultGroupException, MembershipChangeCausingLicenseException {
        final Set<String> requiredDefaultGroups = ProductUtils.getRequiredDefaultGroups(requiredProducts);
        this.assertAddUsersToGroupsValidation(allProducts, Either.left(requiredSeats), requiredDefaultGroups, false, noUserInContext);
        return new UserProvisioningService.Reservation(){

            @Override
            public Map<Product, Either<Failure, GrantProductAccessResult>> apply(@Nullable Set<String> requestedUserNames) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, NoDefaultGroupException, OperationFailedException, MembershipChangeCausingLicenseException, LicenseExceededException {
                Preconditions.checkArgument((requestedUserNames.size() <= requiredSeats ? 1 : 0) != 0);
                Map results = UserProvisioningServiceImpl.this.addUsersToGroupsAlreadyValidated(requestedUserNames, requiredDefaultGroups, noUserInContext);
                return FailureUtils.mapResultsToEffectiveProducts(allProducts, requiredProducts, requestedUserNames, requiredDefaultGroups, results);
            }
        };
    }

    @Override
    public Map<String, BulkAddResult<String>> addUsersToGroups(List<Product> allProducts, Set<String> requestedUserNames, Set<String> groups) throws DirectoryNotFoundException, MembershipChangeCausingLicenseException, OperationFailedException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, LicenseExceededException, DirectoryPermissionException {
        return this.addUsersToGroups(allProducts, requestedUserNames, groups, false, false);
    }

    @Override
    public Map<String, BulkAddResult<String>> addUsersToGroups(List<Product> allProducts, Set<String> requestedUserNames, Set<String> groups, boolean byPassInactiveUserFilter, boolean noUserInContext) throws DirectoryNotFoundException, ReadOnlyGroupException, OperationFailedException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, LicenseExceededException, MembershipChangeCausingLicenseException {
        this.assertAddUsersToGroupsValidation(allProducts, Either.right(requestedUserNames), groups, byPassInactiveUserFilter, noUserInContext);
        return this.addUsersToGroupsAlreadyValidated(requestedUserNames, groups, noUserInContext);
    }

    private void assertAddUsersToGroupsValidation(List<Product> allProducts, Either<Integer, Set<String>> requestedUsers, Set<String> groups, boolean byPassInactiveUserFilter, boolean noUserInContext) throws DirectoryNotFoundException, LicenseExceededException, OperationFailedException, MembershipChangeCausingLicenseException {
        if (!noUserInContext) {
            this.assertNoSysAdminGroupsIfNotSysAdmin(groups);
        }
        if (requestedUsers.isLeft()) {
            this.assertSufficientLicenseSeats(allProducts, groups, (Integer)requestedUsers.left().get());
        } else {
            this.assertSufficientLicenseSeats(allProducts, groups, (Set)requestedUsers.right().get(), byPassInactiveUserFilter);
        }
    }

    private Map<String, BulkAddResult<String>> addUsersToGroupsAlreadyValidated(Set<String> requestedUserNames, Set<String> groups, boolean noUserInContext) throws DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, OperationFailedException, DirectoryPermissionException {
        if (!noUserInContext) {
            this.assertPermissionToModifyUsers(requestedUserNames);
        }
        this.assertNoServiceDeskUsers(requestedUserNames);
        return this.addUsersToGroupsDirect(requestedUserNames, groups);
    }

    private Map<String, BulkAddResult<String>> addUsersToGroupsDirect(Set<String> requestedUserNames, Set<String> groups) throws DirectoryNotFoundException, GroupNotFoundException, DirectoryPermissionException, OperationFailedException {
        HashMap<String, BulkAddResult<String>> results = new HashMap<String, BulkAddResult<String>>();
        for (String group : groups) {
            results.put(group, (BulkAddResult<String>)this.directoryManager.addAllUsersToGroup(this.directoryLocator.getDirectoryId(), requestedUserNames, group));
        }
        return results;
    }

    @Override
    public SeatsEntity getSeatsEntityForProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        Supplier<Set<String>> grantedUsers = this.findUsersGrantedAccessToProductSupplier(product);
        Option<Integer> available = this.calculateAvailableSeats(product, grantedUsers);
        int used = this.calculateUsedSeats(product, grantedUsers);
        boolean isUnlimited = available.isEmpty();
        return new SeatsEntity(available, used, isUnlimited);
    }

    @Override
    public Option<Integer> getAvailableSeatsForProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        return this.getSeatsEntityForProduct(product).getAvailable();
    }

    @Override
    public Integer getUserCountForProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        return this.getSeatsEntityForProduct(product).getUsed();
    }

    private Option<Integer> calculateAvailableSeats(Product product, Supplier<Set<String>> grantedUsers) throws DirectoryNotFoundException, OperationFailedException {
        return this.calculateAvailableSeats(product, grantedUsers, this.directoryManager, this.directoryLocator);
    }

    private int calculateUsedSeats(Product product, Supplier<Set<String>> grantedUsers) throws DirectoryNotFoundException, OperationFailedException {
        return this.calculateUsedSeats(product, grantedUsers, this.directoryManager, this.directoryLocator);
    }

    @Override
    public Map<Product, AccessLevel> getAccessLevel(String username, List<Product> appConfigs) throws DirectoryNotFoundException, OperationFailedException {
        return UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), this.getGroupsForUser(username), appConfigs);
    }

    @Override
    public Set<String> getAllLoginGroups(Product product) {
        if (product.hasConfig()) {
            ProductConfig productConfig = (ProductConfig)product.getConfig().right().get();
            return UserProvisioningServiceImpl.getGroupsForAccessLevels(productConfig, productConfig.getCanLoginLevels());
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<String> getAllLoginUsers(Product product) {
        if (product.hasConfig()) {
            ProductConfig productConfig = (ProductConfig)product.getConfig().right().get();
            return UserProvisioningServiceImpl.getIndividualsForAccessLevels(productConfig, productConfig.getCanLoginLevels());
        }
        return ImmutableSet.of();
    }

    @Override
    public Collection<IntertwinedConfiguration> detectIntertwinedConfigurations(List<Product> products) {
        ImmutableList.Builder conflicts = ImmutableList.builder();
        HashSet checked = Sets.newHashSet();
        for (Product outerProduct : products) {
            if (!outerProduct.hasConfig()) continue;
            ProductConfig outerConfig = (ProductConfig)outerProduct.getConfig().right().get();
            Set<String> outerDefaultUsersGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(outerProduct);
            Sets.SetView outerLoginGroups = Sets.difference(this.getAllLoginGroups(outerProduct), UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(outerConfig));
            for (Product innerProduct : products) {
                Sets.SetView loginGroupsOverlap;
                Sets.SetView defaultUseOverlapForInner;
                if (!innerProduct.hasConfig()) continue;
                ProductConfig innerConfig = (ProductConfig)innerProduct.getConfig().right().get();
                if (outerProduct.equals(innerProduct) || checked.contains(Pair.pair(innerProduct, outerProduct))) continue;
                Set<String> innerDefaultUsersGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(innerProduct);
                Sets.SetView innerLoginGroups = Sets.difference(this.getAllLoginGroups(innerProduct), UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(outerConfig));
                Sets.SetView defaultUseOverlapForOuter = Sets.intersection(outerDefaultUsersGroups, (Set)innerLoginGroups);
                if (!defaultUseOverlapForOuter.isEmpty()) {
                    conflicts.add((Object)new GrantingUseAccessSideEffect(outerProduct, innerProduct, (Iterable<String>)defaultUseOverlapForOuter));
                }
                if (!(defaultUseOverlapForInner = Sets.intersection(innerDefaultUsersGroups, (Set)outerLoginGroups)).isEmpty()) {
                    conflicts.add((Object)new GrantingUseAccessSideEffect(innerProduct, outerProduct, (Iterable<String>)defaultUseOverlapForInner));
                }
                if (!(loginGroupsOverlap = Sets.intersection((Set)outerLoginGroups, (Set)innerLoginGroups)).isEmpty()) {
                    conflicts.add((Object)new RevokingUseAccessSideEffect(outerProduct, innerProduct, (Iterable<String>)loginGroupsOverlap));
                }
                checked.add(Pair.pair(outerProduct, innerProduct));
            }
        }
        return conflicts.build();
    }

    @Override
    public Either<ConflictingConfiguration, Set<String>> updateAccessLevel(String username, Map<Product, AccessLevel> targetAccessLevels, boolean bypassValidation, List<Product> products) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Set<String> groups = this.getGroupsForUser(username);
        Map<Product, AccessLevel> originalAccessLevels = UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), groups, products);
        return this.updateAccessLevel(products, username, groups, originalAccessLevels, targetAccessLevels, bypassValidation);
    }

    @Override
    public Either<ConflictingConfiguration, Set<String>> updateUseAccessLevel(String username, Map<Product, Boolean> targetUseAccessLevels, boolean bypassValidation, List<Product> products) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Set<String> groups = this.getGroupsForUser(username);
        Map<Product, AccessLevel> originalAccessLevels = UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), groups, products);
        Map<Product, AccessLevel> targetAccessLevels = this.calculateTargetUseAccessLevel(products, originalAccessLevels, targetUseAccessLevels);
        return this.updateAccessLevel(products, username, groups, originalAccessLevels, targetAccessLevels, bypassValidation);
    }

    @Override
    public Set<String> findUsernamesExcludedFromLicenseCount(Product product) throws DirectoryNotFoundException, OperationFailedException {
        HashSet<String> excluded = new HashSet<String>();
        excluded.addAll(this.getUsersToBeExcludedFromSeatCount(product, this.directoryManager, this.directoryLocator));
        return excluded;
    }

    @Override
    public Set<Product> getDefaultProducts(List<Product> products) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(products, this.IS_DEFAULT_PRODUCT));
    }

    @Override
    public Map<Product, Boolean> getProductDefaults(List<Product> products) {
        return ImmutableMapUtils.toMap(products, this.TO_PRODUCT_DEFAULTS_ENTITY);
    }

    @Override
    public void updateProductDefaults(Map<Product, Boolean> productDefaultMap) {
        for (Map.Entry<Product, Boolean> entry : productDefaultMap.entrySet()) {
            this.pluginSettings.put(UserProvisioningServiceImpl.defaultProductKeyFor(entry.getKey().getProductId()), (Object)entry.getValue().toString());
        }
    }

    private boolean isDefaultProduct(ProductId productId) {
        Object maybeDefaultAccessSetting = this.pluginSettings.get(UserProvisioningServiceImpl.defaultProductKeyFor(productId));
        if (maybeDefaultAccessSetting == null) {
            return true;
        }
        return Boolean.parseBoolean((String)maybeDefaultAccessSetting);
    }

    @VisibleForTesting
    static String defaultProductKeyFor(ProductId productId) {
        return DEFAULT_APP_PLUGIN_SETTINGS_KEY + productId;
    }

    private Option<Integer> calculateAvailableSeats(Product product, Supplier<Set<String>> grantedUsers, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        Either<ProductAccessError, ProductConfig> maybeConfig = product.getConfig();
        if (maybeConfig.isRight()) {
            LicenseInformationEntity license = ((ProductConfig)maybeConfig.right().get()).getLicense();
            if (license.getLimit() != LicenseInformationEntity.UNLIMITED.intValue()) {
                int licenseLimit = license.getLimit();
                int usedSeats = this.calculateUsedSeats(product, grantedUsers, directoryManager, directoryLocator);
                return Option.some(licenseLimit - usedSeats);
            }
            return Option.none();
        }
        log.debug("Unable to calculate seats, as the product configuration is not available");
        throw new OperationFailedException();
    }

    private int calculateUsedSeats(Product product, Supplier<Set<String>> grantedUsers, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        return this.calculateUsernamesUsingSeats(product, grantedUsers, directoryManager, directoryLocator).size();
    }

    private Set<String> calculateUsernamesUsingSeats(Product product, Supplier<Set<String>> grantedUsers, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        Set<String> usersToBeExcludedFromSeatCount = this.getUsersToBeExcludedFromSeatCount(product, directoryManager, directoryLocator);
        Sets.SetView usersWithSeatsToBeCounted = Sets.difference((Set)((Set)grantedUsers.get()), usersToBeExcludedFromSeatCount);
        return usersWithSeatsToBeCounted;
    }

    private Set<String> getUsersToBeExcludedFromSeatCount(Product product, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSet.Builder excludedUsers = ImmutableSet.builder();
        if (product.hasConfig()) {
            ProductConfig productConfig = (ProductConfig)product.getConfig().right().get();
            Set<String> excludedGroupsFromCount = UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(productConfig);
            for (String excludedGroupName : excludedGroupsFromCount) {
                MembershipQuery<String> query = QueryUtils.getMembersOfGroupQuery(excludedGroupName, 0, -1);
                List usersInExcludedGroup = directoryManager.searchDirectGroupRelationships(directoryLocator.getDirectoryId(), query);
                excludedUsers.addAll((Iterable)usersInExcludedGroup);
            }
        }
        for (Product nonPlatformProduct : this.productService.getNonPlatformProducts(product)) {
            excludedUsers.addAll((Iterable)this.findUsernamesGrantedAccessToProduct(nonPlatformProduct));
        }
        return excludedUsers.build();
    }

    private static Map<Product, AccessLevel> calculateAccessLevel(Option<String> mayBeUsername, Set<String> groups, List<Product> products) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Product product : products) {
            builder.put((Object)product, (Object)UserProvisioningServiceImpl.calculateAccessLevelForProduct(mayBeUsername, groups, product));
        }
        return builder.build();
    }

    private static AccessLevel calculateAccessLevelForProduct(Option<String> mayBeUsername, Set<String> groupNames, Product product) {
        HashSet accessLevelsForUser = Sets.newHashSet();
        for (AccessLevel accessLevel : AccessLevel.values()) {
            if (!UserProvisioningServiceImpl.userHasAccessLevel(mayBeUsername, accessLevel, groupNames, product)) continue;
            accessLevelsForUser.add(accessLevel);
        }
        return UserProvisioningServiceImpl.canUserLogin(accessLevelsForUser, product) ? AccessLevel.findHighest(accessLevelsForUser) : AccessLevel.NONE;
    }

    private static boolean userHasAccessLevel(Option<String> mayBeUsername, AccessLevel accessLevel, Set<String> groups, Product product) {
        PermissionEntity permissionEntity;
        if (product.getConfig().isRight() && (permissionEntity = ((ProductConfig)product.getConfig().right().get()).getPermissions(accessLevel)) != null) {
            Set<String> groupsWithPermission = permissionEntity.getGroups().keySet();
            boolean userBelongsToGroupsWithPermission = !Sets.intersection(groupsWithPermission, groups).isEmpty();
            boolean userHasDirectPermission = !mayBeUsername.isEmpty() && permissionEntity.getUsers().contains(mayBeUsername.get());
            return userBelongsToGroupsWithPermission || userHasDirectPermission;
        }
        return false;
    }

    private static boolean canUserLogin(Set<AccessLevel> accessLevelsForUser, Product product) {
        if (product.getConfig().isRight()) {
            return !Sets.intersection(((ProductConfig)product.getConfig().right().get()).getCanLoginLevels(), accessLevelsForUser).isEmpty();
        }
        return false;
    }

    private Set<String> getGroupsForUser(String username) throws DirectoryNotFoundException, OperationFailedException {
        return ImmutableSet.copyOf((Collection)this.directoryManager.searchNestedGroupRelationships(this.directoryLocator.getDirectoryId(), QueryUtils.getMembershipQuery(username)));
    }

    private Map<Product, AccessLevel> calculateTargetUseAccessLevel(List<Product> appConfigs, final Map<Product, AccessLevel> originalAccessLevels, Map<Product, Boolean> targetUseAccessLevels) {
        return ImmutableMapUtils.transform(Maps.filterKeys(targetUseAccessLevels, (Predicate)Predicates.in(appConfigs)), new Function<Map.Entry<Product, Boolean>, Map.Entry<Product, AccessLevel>>(){

            public Map.Entry<Product, AccessLevel> apply(Map.Entry<Product, Boolean> input) {
                Product product = input.getKey();
                AccessLevel originalAccessLevel = (AccessLevel)((Object)originalAccessLevels.get(product));
                Preconditions.checkState((originalAccessLevel != null ? 1 : 0) != 0);
                AccessLevel targetAccessLevel = input.getValue().booleanValue() ? (originalAccessLevel == AccessLevel.NONE ? AccessLevel.USE : originalAccessLevel) : AccessLevel.NONE;
                return Maps.immutableEntry((Object)product, (Object)((Object)targetAccessLevel));
            }
        });
    }

    private Either<ConflictingConfiguration, Set<String>> updateAccessLevel(List<Product> products, String username, Set<String> groups, Map<Product, AccessLevel> originalAccessLevels, Map<Product, AccessLevel> targetAccessLevels, boolean bypassValidation) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException, CredentialsRequiredException, ResponseException {
        Map<Product, AccessLevel> accessLevelAfterApplyGroupsDelta;
        Map<Product, Delta<AccessLevel>> appsDelta = this.getProductDelta(products, originalAccessLevels, targetAccessLevels);
        Delta<Set<String>> groupsDelta = this.calculateGroupsDelta(groups, products, appsDelta);
        ImmutableSet remainingGroups = ImmutableSet.builder().addAll((Iterable)Sets.difference(groups, (Set)((Set)groupsDelta.toRemove))).addAll((Iterable)groupsDelta.toAdd).build();
        Map<Product, AccessLevel> map = accessLevelAfterApplyGroupsDelta = bypassValidation ? targetAccessLevels : UserProvisioningServiceImpl.calculateAccessLevel(Option.none(), (Set<String>)remainingGroups, products);
        if (accessLevelAfterApplyGroupsDelta.equals(targetAccessLevels)) {
            this.updateGroupsForUser(username, groupsDelta);
            this.revokeIndividualAccess(username, appsDelta, products);
            return Either.right(remainingGroups);
        }
        return Either.left(new ConflictingConfiguration(targetAccessLevels, accessLevelAfterApplyGroupsDelta));
    }

    private void updateGroupsForUser(String username, Delta<Set<String>> groupsDelta) throws UserModificationNotAllowedException, SysadminGroupModificationNotAllowedException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, ReadOnlyGroupException, GroupNotFoundException, DirectoryPermissionException {
        try {
            this.preUpdateCheck(username, groupsDelta);
            for (String group : (Set)groupsDelta.toRemove) {
                this.directoryManager.removeUserFromGroup(this.directoryLocator.getDirectoryId(), username, group);
            }
            for (String group : (Set)groupsDelta.toAdd) {
                this.directoryManager.addUserToGroup(this.directoryLocator.getDirectoryId(), username, group);
            }
        }
        catch (MembershipAlreadyExistsException | MembershipNotFoundException throwable) {
            // empty catch block
        }
    }

    private void preUpdateCheck(String username, Delta<Set<String>> groupsDelta) throws SysadminGroupModificationNotAllowedException, DirectoryNotFoundException, OperationFailedException, UserModificationNotAllowedException {
        Option<Message> userValidationResults;
        if (this.userAndGroupCheckService.isCurrentUser(username)) {
            for (String groupName : (Set)groupsDelta.toRemove) {
                Option<ValidationResults> validationResults = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName);
                if (!validationResults.isDefined()) continue;
                throw new SysadminGroupModificationNotAllowedException((ValidationResults)validationResults.get());
            }
        }
        if ((userValidationResults = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username)).isDefined()) {
            throw new UserModificationNotAllowedException((Message)userValidationResults.get());
        }
        ImmutableList forbiddenGroupNames = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)ImmutableSet.builder().addAll((Iterable)groupsDelta.toAdd).addAll((Iterable)groupsDelta.toRemove).build(), (Predicate)Predicates.not(UserAndGroupCheckServiceFunctions.canCurrentUserModifyGroup(this.userAndGroupCheckService))));
        if (!forbiddenGroupNames.isEmpty()) {
            throw new SysadminGroupModificationNotAllowedException((List<String>)forbiddenGroupNames);
        }
    }

    private Map<Product, Delta<AccessLevel>> getProductDelta(List<Product> products, Map<Product, AccessLevel> originalAccessLevels, Map<Product, AccessLevel> targetAccessLevels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Product product : products) {
            AccessLevel oldLevel = originalAccessLevels.get(product);
            AccessLevel targetLevel = targetAccessLevels.get(product);
            if (oldLevel == null || targetLevel == null || oldLevel == targetLevel) continue;
            builder.put((Object)product, new Delta<AccessLevel>(oldLevel, targetLevel));
        }
        return builder.build();
    }

    private Delta<Set<String>> calculateGroupsDelta(Set<String> existingGroups, List<Product> products, Map<Product, Delta<AccessLevel>> productDeltas) {
        HashSet groupsMustNotBePresent = Sets.newHashSet();
        HashSet groupsShouldBePresent = Sets.newHashSet();
        ImmutableMap<ProductId, Product> productMap = ImmutableMapUtils.uniqueIndex(products, new Function<Product, ProductId>(){

            public ProductId apply(@Nullable Product input) {
                return input.getProductId();
            }
        });
        for (Map.Entry<Product, Delta<AccessLevel>> entry : productDeltas.entrySet()) {
            Product product = entry.getKey();
            Delta<AccessLevel> delta = entry.getValue();
            Product productFromMap = (Product)productMap.get(product.getProductId());
            if (!productFromMap.hasConfig()) continue;
            ProductConfig productConfig = (ProductConfig)productFromMap.getConfig().right().get();
            if (delta.toAdd == AccessLevel.NONE) {
                groupsMustNotBePresent.addAll(this.getAllLoginGroups(productFromMap));
                continue;
            }
            if (delta.toRemove == AccessLevel.NONE) {
                Set<String> defaultLoginGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(productFromMap);
                groupsShouldBePresent.addAll(Sets.difference(defaultLoginGroups, (Set)groupsMustNotBePresent));
            }
            for (AccessLevel level : AccessLevel.rangeFromHighToLow((AccessLevel)((Object)delta.toRemove), (AccessLevel)((Object)delta.toAdd))) {
                Set<String> groupsForOldLevel = UserProvisioningServiceImpl.getGroupsForAccessLevel(productConfig, level);
                groupsMustNotBePresent.addAll(groupsForOldLevel);
            }
            Set<String> groupsForNewLevel = UserProvisioningServiceImpl.getGroupsForAccessLevel(productConfig, (AccessLevel)((Object)delta.toAdd));
            if (!Sets.intersection((Set)Sets.union((Set)Sets.difference(existingGroups, (Set)groupsMustNotBePresent), (Set)groupsShouldBePresent), groupsForNewLevel).isEmpty()) continue;
            Set<String> defaultGroupsForNewLevel = UserProvisioningServiceImpl.getDefaultGroupsForAccessLevels(productFromMap, (AccessLevel)((Object)delta.toAdd));
            groupsShouldBePresent.addAll(defaultGroupsForNewLevel);
        }
        Sets.SetView groupsToLeave = Sets.intersection(existingGroups, (Set)groupsMustNotBePresent);
        Sets.SetView groupsToJoin = Sets.difference((Set)groupsShouldBePresent, existingGroups);
        return new Delta<Sets.SetView>(groupsToLeave, groupsToJoin);
    }

    private void revokeIndividualAccess(String username, Map<Product, Delta<AccessLevel>> appsDelta, List<Product> products) throws CredentialsRequiredException, ResponseException {
        ImmutableMap<ProductId, Product> productMap = ImmutableMapUtils.uniqueIndex(products, new Function<Product, ProductId>(){

            public ProductId apply(@Nullable Product input) {
                return input.getProductId();
            }
        });
        for (Map.Entry<Product, Delta<AccessLevel>> entry : appsDelta.entrySet()) {
            Product product = entry.getKey();
            if (!product.hasConfig()) continue;
            ProductConfig config = (ProductConfig)product.getConfig().right().get();
            Delta<AccessLevel> delta = entry.getValue();
            HashSet accessLevelsMustNotBePresent = Sets.newHashSet();
            if (delta.toAdd == AccessLevel.NONE) {
                ImmutableSet canLoginLevels = product.hasConfig() ? ((ProductConfig)product.getConfig().right().get()).getCanLoginLevels() : ImmutableSet.of();
                accessLevelsMustNotBePresent.addAll(canLoginLevels);
            } else {
                accessLevelsMustNotBePresent.addAll(AccessLevel.rangeFromHighToLow((AccessLevel)((Object)delta.toRemove), (AccessLevel)((Object)delta.toAdd)));
            }
            for (AccessLevel accessLevel : accessLevelsMustNotBePresent) {
                Set<String> individuals = UserProvisioningServiceImpl.getIndividualsForAccessLevel(config, accessLevel);
                if (!individuals.contains(username)) continue;
                product.revokeUser(username, accessLevel);
            }
        }
    }

    private static Set<String> getAllGroupsExcludedFromLicenseCounting(ProductConfig product) {
        Set<String> groupsForAccessLevels = UserProvisioningServiceImpl.getGroupsForAccessLevels(product, product.getAccessLevelsExcludedFromCount());
        return Sets.union(product.getGroupsExcludedFromCount(), groupsForAccessLevels);
    }

    private static Set<String> getGroupsForAccessLevels(ProductConfig product, Set<AccessLevel> canLogin) {
        return ImmutableSet.copyOf(com.atlassian.fugue.Iterables.flatMap(canLogin, UserProvisioningServiceImpl.accessLevelToGroupNamesMapper(product)));
    }

    private static Set<String> getDefaultUsersGroups(Product product) {
        return UserProvisioningServiceImpl.getDefaultGroupsForAccessLevels(product, AccessLevel.USE);
    }

    private static Set<String> getDefaultGroupsForAccessLevels(Product product, AccessLevel level) {
        if (product.hasConfig()) {
            ProductConfig config = (ProductConfig)product.getConfig().right().get();
            return Maps.filterValues(config.getPermissions(level).getGroups(), (Predicate)new Predicate<GroupAttributesEntity>(){

                public boolean apply(GroupAttributesEntity groupAttributesEntity) {
                    return groupAttributesEntity.isDefault();
                }
            }).keySet();
        }
        return ImmutableSet.of();
    }

    private static Set<String> getGroupsForAccessLevel(ProductConfig product, AccessLevel level) {
        return ImmutableSet.copyOf((Iterable)((Iterable)UserProvisioningServiceImpl.accessLevelToGroupNamesMapper(product).apply((Object)level)));
    }

    private static Function<AccessLevel, Iterable<String>> accessLevelToGroupNamesMapper(final ProductConfig product) {
        return new Function<AccessLevel, Iterable<String>>(){

            public Iterable<String> apply(AccessLevel accessLevel) {
                return product.getGroups(accessLevel);
            }
        };
    }

    private static Set<String> getIndividualsForAccessLevels(ProductConfig product, Set<AccessLevel> levels) {
        return ImmutableSet.copyOf(com.atlassian.fugue.Iterables.flatMap(levels, UserProvisioningServiceImpl.accessLevelToIndividualsMapper(product)));
    }

    private static Set<String> getIndividualsForAccessLevel(ProductConfig product, AccessLevel level) {
        return ImmutableSet.copyOf((Iterable)((Iterable)UserProvisioningServiceImpl.accessLevelToIndividualsMapper(product).apply((Object)level)));
    }

    private static Function<AccessLevel, Iterable<String>> accessLevelToIndividualsMapper(final ProductConfig product) {
        return new Function<AccessLevel, Iterable<String>>(){

            public Iterable<String> apply(AccessLevel accessLevel) {
                PermissionEntity permissionEntity = product.getPermissions(accessLevel);
                return permissionEntity != null ? permissionEntity.getUsers() : ImmutableSet.of();
            }
        };
    }

    @Override
    public Set<String> filterOutInactiveUsers(Set<String> usernames) {
        List partitionedUsernames = Lists.partition((List)ImmutableList.copyOf(usernames), (int)50);
        ImmutableSet.Builder activeUsernames = ImmutableSet.builder();
        for (List currentBatch : partitionedUsernames) {
            activeUsernames.addAll(this.getActiveUsernamesInBatch(currentBatch));
        }
        return activeUsernames.build();
    }

    public void assertNoSysAdminGroupsIfNotSysAdmin(Set<String> groups) {
        ImmutableList forbiddenGroupNames = ImmutableList.copyOf((Iterable)Iterables.filter(groups, (Predicate)Predicates.not(UserAndGroupCheckServiceFunctions.canCurrentUserModifyGroup(this.userAndGroupCheckService))));
        if (!forbiddenGroupNames.isEmpty()) {
            throw new SysadminGroupModificationNotAllowedException((List<String>)forbiddenGroupNames);
        }
    }

    public void assertPermissionToModifyUsers(Set<String> usernames) {
        for (String username : usernames) {
            Option<Message> accessViolation = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username);
            if (!accessViolation.isDefined()) continue;
            throw new UserModificationNotAllowedException((Message)accessViolation.get());
        }
    }

    public void assertNoServiceDeskUsers(Set<String> usernames) {
        Set requestors = Sets.filter(usernames, ServiceDeskValidationFunctions.isServiceDeskRequestor(this.directoryLocator, this.directoryManager));
        if (!requestors.isEmpty()) {
            throw new ProductAccessChangeNotAllowedException(requestors);
        }
    }

    private void assertSufficientLicenseSeats(List<Product> allProducts, Set<String> groups, Set<String> usersToAdd, boolean byPassInactiveUserFilter) throws MembershipChangeCausingLicenseException {
        LicenseCheckFunctionAddUsersToGroups validationFunction;
        Set<Product> effectiveProducts = ProductUtils.getAvailableProductsAccessibleViaGroups(allProducts, groups);
        Set<Product> licenseProducts = ProductUtils.excludeUnnecessaryPlatformProducts(effectiveProducts);
        ImmutableMap licenseExceededErrors = ImmutableMapUtils.collectByValue(ImmutableMapUtils.toMap(licenseProducts, validationFunction = new LicenseCheckFunctionAddUsersToGroups(groups, usersToAdd, this, byPassInactiveUserFilter)), Functions.identity());
        if (!licenseExceededErrors.isEmpty()) {
            throw new MembershipChangeCausingLicenseException((Map<Product, MembershipChangeCausingLicenseExceeded>)licenseExceededErrors);
        }
    }

    private void assertSufficientLicenseSeats(List<Product> allProducts, Set<String> groups, int requiredSeats) throws LicenseExceededException, DirectoryNotFoundException, OperationFailedException {
        LicenseCheckSeatsFunction validationFunction;
        Set<Product> effectiveProducts = ProductUtils.getAvailableProductsAccessibleViaGroups(allProducts, groups);
        Set<Product> licenseProducts = ProductUtils.excludeUnnecessaryPlatformProducts(effectiveProducts);
        ImmutableMap licenseExceededErrors = ImmutableMapUtils.collectByValue(ImmutableMapUtils.toMap(licenseProducts, validationFunction = new LicenseCheckSeatsFunction(this, requiredSeats)), Functions.identity());
        if (!licenseExceededErrors.isEmpty()) {
            throw new LicenseExceededException((Map<Product, LicenseExceeded>)licenseExceededErrors);
        }
    }

    private Iterable<String> getActiveUsernamesInBatch(List<String> usernames) {
        HashSet<PropertyRestriction> usernameRestrictions = new HashSet<PropertyRestriction>(usernames.size());
        for (String username : usernames) {
            usernameRestrictions.add(Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)username));
        }
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf(usernameRestrictions), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)})).returningAtMost(usernames.size());
        try {
            return this.directoryManager.searchUsers(this.directoryLocator.getDirectoryId(), query);
        }
        catch (CrowdException e) {
            log.error("Error finding active users", (Throwable)e);
            return usernames;
        }
    }

    public SortedSet<String> findUsernamesGrantedAccessToProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSortedSet.Builder userNamesBuilder = ImmutableSortedSet.naturalOrder();
        if (product.hasConfig()) {
            ProductConfig productConfig = (ProductConfig)product.getConfig().right().get();
            for (String groupName : this.getAllLoginGroups(product)) {
                MembershipQuery<User> query = QueryUtils.getMembersOfGroupQueryAsUser(groupName, 0, -1);
                for (User user : this.directoryManager.searchDirectGroupRelationships(this.directoryLocator.getDirectoryId(), query)) {
                    if (!user.isActive()) continue;
                    userNamesBuilder.add((Object)user.getName());
                }
            }
            Set<AccessLevel> canLoginAccessLevels = productConfig.getCanLoginLevels();
            for (String username : UserProvisioningServiceImpl.getIndividualsForAccessLevels(productConfig, canLoginAccessLevels)) {
                try {
                    if (!this.directoryManager.findUserByName(this.directoryLocator.getDirectoryId(), username).isActive()) continue;
                    userNamesBuilder.add((Object)username);
                }
                catch (UserNotFoundException e) {
                    log.warn("Whilst trying to calculate licence useage, User " + username + " does not exist");
                }
            }
        }
        return userNamesBuilder.build();
    }

    @Override
    public Set<String> findUsernamesTakingLicenseSeatsToProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        Supplier<Set<String>> usernamesWithAccessSupplier = this.findUsersGrantedAccessToProductSupplier(product);
        return this.calculateUsernamesUsingSeats(product, usernamesWithAccessSupplier, this.directoryManager, this.directoryLocator);
    }

    public SortedSet<User> findUsersGrantedAccessToProduct(Product product) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSortedSet.Builder userBuilder = ImmutableSortedSet.naturalOrder();
        if (product.hasConfig()) {
            ProductConfig productConfig = (ProductConfig)product.getConfig().right().get();
            for (String groupName : this.getAllLoginGroups(product)) {
                MembershipQuery<User> query = QueryUtils.getMembersOfGroupQueryAsUser(groupName, 0, -1);
                userBuilder.addAll((Iterable)this.directoryManager.searchDirectGroupRelationships(this.directoryLocator.getDirectoryId(), query));
            }
            Set<AccessLevel> canLoginAccessLevels = productConfig.getCanLoginLevels();
            for (String username : UserProvisioningServiceImpl.getIndividualsForAccessLevels(productConfig, canLoginAccessLevels)) {
                try {
                    userBuilder.add((Object)this.directoryManager.findUserByName(this.directoryLocator.getDirectoryId(), username));
                }
                catch (UserNotFoundException e) {
                    log.warn("User \"" + username + "\" has permissions to an product but the user does not actually exist.", (Throwable)e);
                }
            }
        }
        return userBuilder.build();
    }

    private Supplier<Set<String>> findUsersGrantedAccessToProductSupplier(final Product product) {
        return Suppliers.memoize((Supplier)new Supplier<Set<String>>(){

            public Set<String> get() {
                try {
                    return UserProvisioningServiceImpl.this.findUsernamesGrantedAccessToProduct(product);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class Delta<T> {
        public final T toRemove;
        public final T toAdd;

        public Delta(T toRemove, T toAdd) {
            this.toRemove = toRemove;
            this.toAdd = toAdd;
        }
    }
}

