/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDescriptionEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAppAccessException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAppAccessUpdateException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotConfigurableException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.fugue.Option;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.host.HostEntity;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public interface ProductService {
    public void updateHostConfig(HostEntity var1);

    public Option<HostEntity> retrieve(String var1);

    public List<Product> fetchProducts();

    public List<ProductDescriptionEntity> fetchProductDescription();

    public List<Product> fetchProducts(Iterable<ProductId> var1);

    public Option<Product> getProduct(ProductId var1);

    public void deleteHostConfig(String var1) throws IOException;

    public void grantAccess(ProductId var1, String var2, AccessLevel var3, UserProvisioningService var4) throws ProductNotFoundException, ProductAppAccessException, LicenseExceededException, GroupNotFoundException;

    public void grantDefaultAccess(ProductId var1, String var2, UserProvisioningService var3) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException;

    public void removeDefaultAccess(ProductId var1, String var2) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException;

    public void approveAccess(ProductId var1, String var2, UserProvisioningService var3) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException;

    public void rejectAccess(ProductId var1, String var2, UserProvisioningService var3) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException;

    public void revokeAccess(ProductId var1, String var2, AccessLevel var3) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException;

    public boolean hasDefaultUseAccess(List<Product> var1, String var2);

    public boolean hasAdminAccess(List<Product> var1, String var2);

    public boolean hasDefaultAccess(List<Product> var1, String var2);

    public List<Product> getNonPlatformProducts(Product var1);

    public void revokeAllAccess(List<String> var1);

    public Set<String> getGroupsRequiringApproval(Product var1, AccessLevel var2, boolean var3);
}

