/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.ApplicationId;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ProductId {
    private static final String HOSTED_PREFIX = "product";
    private static final String SEPARATOR = ":";
    private static final int HOSTED_SEPARATORS = 2;
    @JsonProperty
    private final String id;

    @JsonCreator
    public ProductId(String productId) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)productId);
        if (productId.startsWith(HOSTED_PREFIX) && StringUtils.countMatches(productId, SEPARATOR) == 2) {
            this.id = productId;
        } else {
            UUID.fromString(productId);
            this.id = productId;
        }
    }

    public ProductId(ApplicationId applicationLinkID) {
        this.id = applicationLinkID.get();
    }

    public static ProductId fromHostIdAndProductKey(String hostId, String productKey) {
        return new ProductId("product:" + hostId + SEPARATOR + productKey);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProductId otherId = (ProductId)other;
        return this.id.equals(otherId.id);
    }

    public int hashCode() {
        return 31 * this.id.hashCode();
    }

    public static Set<ProductId> getProductIds(Iterable<String> productIds) {
        Iterable objects = Iterables.transform(productIds, (Function)new Function<String, ProductId>(){

            public ProductId apply(@Nullable String productId) {
                return new ProductId(productId);
            }
        });
        return ImmutableSet.copyOf((Iterable)objects);
    }
}

