/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;

public class ConfigurationEntityFunctions {
    private static final int UNLIMITED = -1;
    private static Function<Product, Option<Integer>> TO_LICENSE_LIMIT = new Function<Product, Option<Integer>>(){

        public Option<Integer> apply(Product input) {
            int limit;
            Either<ProductAccessError, ProductConfig> maybeConfig = input.getConfig();
            if (maybeConfig.isRight() && (limit = ((ProductConfig)maybeConfig.right().get()).getLicense().getLimit()) != -1) {
                return Option.some(limit);
            }
            return Option.none(Integer.class);
        }
    };

    public static Function<Product, Option<Integer>> toLicenseLimit() {
        return TO_LICENSE_LIMIT;
    }
}

