/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.plugin.usermanagement.service.AtlassianIdService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianIdServiceImpl
implements AtlassianIdService {
    private static final String ONDEMAND_APPLICATION_KEY = "ondemand";
    private static final Logger log = LoggerFactory.getLogger(AtlassianIdServiceImpl.class);
    private final RequestFactory requestFactory;
    private final ExecutorService executorService;
    private final I18nResolver i18nResolver;
    private final String atlassianIdLocation;
    private final String atlassianIdBearerToken;

    public AtlassianIdServiceImpl(RequestFactory requestFactory, ExecutorService executorService, I18nResolver i18nResolver, String atlassianIdLocation, String atlassianIdBearerToken) {
        this.requestFactory = requestFactory;
        this.executorService = executorService;
        this.i18nResolver = i18nResolver;
        this.atlassianIdLocation = atlassianIdLocation;
        this.atlassianIdBearerToken = atlassianIdBearerToken;
    }

    @Override
    public void invite(final @Nonnull String inviter, final @Nonnull String invitee, final @Nullable String text, final @Nullable String continueUrl, final @Nullable Integer daysValidFor, final @Nullable String displayName) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AtlassianIdServiceImpl.this.requestFactory.createRequest(Request.MethodType.POST, AtlassianIdServiceImpl.this.atlassianIdLocation + "/invite").setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + AtlassianIdServiceImpl.this.atlassianIdBearerToken).setEntity((Object)new InvitationEntity(inviter, invitee, displayName, AtlassianIdServiceImpl.ONDEMAND_APPLICATION_KEY, AtlassianIdServiceImpl.this.i18nResolver.getText("ondemand.name"), continueUrl, daysValidFor, text)).execute(new ResponseHandler(){

                        public void handle(Response response) throws ResponseException {
                            if (!response.isSuccessful()) {
                                log.error("Unexpected response from {} received:", (Object)AtlassianIdServiceImpl.this.atlassianIdLocation);
                                log.error("\t{} {}", (Object)response.getStatusCode(), (Object)response.getStatusText());
                                log.error("\t{}", (Object)response.getResponseBodyAsString());
                            }
                        }
                    });
                }
                catch (ResponseException e) {
                    log.error("Error sending an invitation from {} to {}", new Object[]{inviter, invitee, e});
                }
            }
        });
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class InvitationEntity {
        private final String inviter;
        private final String invitee;
        private final String displayName;
        private final String application;
        private final String applicationName;
        private final String continueUrl;
        private final Integer daysValidFor;
        private final String text;

        public InvitationEntity(@Nonnull String inviter, @Nonnull String invitee, @Nullable String displayName, @Nonnull String application, @Nullable String applicationName, @Nullable String continueUrl, @Nullable Integer daysValidFor, @Nullable String text) {
            this.inviter = inviter;
            this.invitee = invitee;
            this.displayName = displayName;
            this.application = application;
            this.applicationName = applicationName;
            this.continueUrl = continueUrl;
            this.daysValidFor = daysValidFor;
            this.text = text;
        }
    }
}

