/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.ApplicationLinkFunctions;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.usermanagement.client.entity.ConfigurationEntity;
import com.atlassian.usermanagement.client.util.ImmutableMapUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLinkConfigServiceImpl
implements ApplicationLinkConfigService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkConfigServiceImpl.class);
    private static final String USER_PROVISIONING_REST_URL = "/rest/userprovisioning/1/config";
    private final I18nResolver i18nResolver;
    private final ApplicationLinkFilteringService applicationLinkService;

    public ApplicationLinkConfigServiceImpl(I18nResolver i18nResolver, ApplicationLinkFilteringService applicationLinkService) {
        this.i18nResolver = i18nResolver;
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    public boolean containsLink(String applicationLinkId) {
        return this.applicationLinkService.getApplicationLink(applicationLinkId).isDefined();
    }

    @Override
    public Option<ReadOnlyApplicationLink> getApplicationLink(String applicationLinkId) {
        return this.applicationLinkService.getApplicationLink(applicationLinkId);
    }

    @Override
    public ReadOnlyApplicationLinkWithConfig fetchConfigForApplication(ReadOnlyApplicationLink applicationLink) {
        return new ApplinkToApplinkWithConfig().apply(applicationLink);
    }

    @Override
    public Iterable<ReadOnlyApplicationLinkWithConfig> fetchAllConfigsForApplications(Iterable<ReadOnlyApplicationLink> applicationLinks) {
        return Iterables.transform(applicationLinks, (Function)new ApplinkToApplinkWithConfig());
    }

    @Override
    public Iterable<ReadOnlyApplicationLinkWithConfig> fetchAllConfigsForApplicationIds(Iterable<String> applicationIds) {
        Iterable applicationLinks = Iterables.filter(this.applicationLinkService.getApplicationLinks(), (Predicate)Predicates.compose((Predicate)Predicates.in((Collection)ImmutableSet.copyOf(applicationIds)), ApplicationLinkFunctions.APPLICATION_LINK_STRING_ID_GETTER));
        return this.fetchAllConfigsForApplications(applicationLinks);
    }

    @Override
    public Iterable<ReadOnlyApplicationLinkWithConfig> fetchAllConfigsForAllApplications() {
        return this.fetchAllConfigsForApplications(this.applicationLinkService.getApplicationLinks());
    }

    @Override
    public Iterable<ReadOnlyApplicationLink> getAllLinksForAllApplications() {
        return this.applicationLinkService.getApplicationLinks();
    }

    @Override
    public Map<ReadOnlyApplicationLink, ConfigurationEntity> fetchAllConfigsAsMapForAllApplications() {
        Function rightMapper = Eithers.rightMapper();
        return ImmutableMapUtils.collectByValue(ImmutableMapUtils.toMap(this.fetchAllConfigsForApplications(this.applicationLinkService.getApplicationLinks()), new Function<ReadOnlyApplicationLinkWithConfig, ReadOnlyApplicationLink>(){

            public ReadOnlyApplicationLink apply(ReadOnlyApplicationLinkWithConfig input) {
                return input.getDelegate();
            }
        }, new Function<ReadOnlyApplicationLinkWithConfig, Either<ProductAccessError, ConfigurationEntity>>(){

            public Either<ProductAccessError, ConfigurationEntity> apply(ReadOnlyApplicationLinkWithConfig input) {
                return input.getConfig();
            }
        }), rightMapper);
    }

    public class ApplinkToApplinkWithConfig
    implements Function<ReadOnlyApplicationLink, ReadOnlyApplicationLinkWithConfig> {
        public ReadOnlyApplicationLinkWithConfig apply(final ReadOnlyApplicationLink applicationLink) {
            try {
                ApplicationLinkRequest request = applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, ApplicationLinkConfigServiceImpl.USER_PROVISIONING_REST_URL);
                Either config = (Either)request.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Either<ProductAccessError, ConfigurationEntity>>(){

                    public Either<ProductAccessError, ConfigurationEntity> handle(Response response) throws ResponseException {
                        if (response.isSuccessful()) {
                            return Either.right(response.getEntity(ConfigurationEntity.class));
                        }
                        log.error("Failed to retrieve ConfigurationEntity for {}: {} {}", new Object[]{applicationLink.getName(), response.getStatusCode(), response.getStatusText()});
                        return Either.left(new ProductAccessError(ApplicationLinkConfigServiceImpl.this.i18nResolver.getText("usermanagement.apps.communication.error", new Serializable[]{applicationLink.getName(), response.getStatusText()})));
                    }
                });
                return new ReadOnlyApplicationLinkWithConfig(applicationLink, config);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Failed to retrieve ConfigurationEntity for {}: {}", (Object)applicationLink.getName(), (Object)e.getMessage());
                ProductAccessError error = new ProductAccessError(ApplicationLinkConfigServiceImpl.this.i18nResolver.getText("usermanagement.apps.communication.error", new Serializable[]{applicationLink.getName(), e.getMessage()}));
                return new ReadOnlyApplicationLinkWithConfig(applicationLink, Either.left(error));
            }
        }
    }
}

