/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource.test;

import com.atlassian.crowd.plugin.usermanagement.common.UriBuilder;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Path(value="mock_agni_server")
@FeatureGuard(value="um.agni.mock")
public class MockAgni {
    private static final String DIRECTORY_API = "DirectoryAPI";
    private static final String USER_PROVISIONING_API = "UserProvisioningAPI";
    private static String DIRECTORY_TYPE = "DirectoryAPI";
    @Context
    private UriInfo uriInfo;
    private final AtomicReference<String> gappsDomain = new AtomicReference();

    @POST
    @Path(value="oauth-callback")
    public String startOAuthDance(@QueryParam(value="redirect_uri") String redirectUri) {
        URI userConsentPage = this.mockAgni().path("google/user-consent").queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]);
        return String.valueOf(userConsentPage);
    }

    @GET
    @Path(value="oauth-callback/complete")
    public Response completeOAuthDance(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="error.code") String errorCode) {
        UriBuilder redirectTo = UriBuilder.fromPath(redirectUri);
        if (StringUtils.isEmpty(errorCode)) {
            this.gappsDomain.set("gapps-domain.com");
        } else {
            redirectTo = redirectTo.queryParam("error.code", errorCode);
        }
        return Response.seeOther((URI)redirectTo.build()).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="google/user-consent")
    public String showUserConsentPage(@QueryParam(value="redirect_uri") String redirectUri) {
        String cancel = this.mockAgni().path("oauth-callback/complete").queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("error.code", new Object[]{"auth_error"}).build(new Object[0]).toString();
        String accept = this.mockAgni().path("oauth-callback/complete").queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]).toString();
        return String.format("<html><body>Agni wants to read users on your domain. Do you want to <a class=\"cancel\" href=\"%s\">cancel</a> or <a class=\"accept\" href=\"%s\">accept</a>?</body></html>", StringEscapeUtils.escapeHtml4(cancel), StringEscapeUtils.escapeHtml4(accept));
    }

    @GET
    @Path(value="gapps-domain")
    @Produces(value={"text/plain"})
    public Response readGappsInfo() {
        String domain = this.gappsDomain.get();
        if (domain != null) {
            return Response.ok((Object)domain).build();
        }
        return Response.status((int)404).build();
    }

    @DELETE
    @Path(value="gapps-domain")
    public Response removeGappsInfo() {
        this.gappsDomain.set(null);
        return Response.ok().build();
    }

    @GET
    @Path(value="gapps-status")
    @Produces(value={"application/json"})
    public Response getStatus() {
        return Response.ok((Object)new AgniStatus(this.gappsDomain.get(), this.gappsDomain.get() != null ? DIRECTORY_TYPE : null, this.gappsDomain.get() != null, null)).build();
    }

    @POST
    @Path(value="shortcut/setupGapps")
    public Response setupGapps(@QueryParam(value="type") String type, @QueryParam(value="domain") String domain) {
        if (StringUtils.isNotBlank(type)) {
            DIRECTORY_TYPE = "legacy".equals(type) ? USER_PROVISIONING_API : DIRECTORY_API;
        }
        if (StringUtils.isNotBlank(domain)) {
            this.gappsDomain.set(domain);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="shortcut/resetGapps")
    public Response resetGappsSetup() {
        DIRECTORY_TYPE = DIRECTORY_API;
        this.gappsDomain.set("");
        return Response.ok().build();
    }

    private javax.ws.rs.core.UriBuilder mockAgni() {
        return this.uriInfo.getBaseUriBuilder().path(MockAgni.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class AgniStatus {
        private final String gappsDomain;
        private final String gappsType;
        private final boolean operational;
        private final String errorText;

        private AgniStatus(String gappsDomain, String gappsType, boolean operational, String errorText) {
            this.gappsDomain = gappsDomain;
            this.gappsType = gappsType;
            this.operational = operational;
            this.errorText = errorText;
        }
    }
}

