/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource.test;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.validation.XForwardedForUtil;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntitySet;
import com.atlassian.crowd.plugin.rest.util.ApplicationEntityTranslator;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="test-application")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
@FeatureGuard(value="um.test.only.rest.resource")
public class ApplicationResourcesForTests {
    @Context
    protected HttpServletRequest request;
    @Context
    protected UriInfo uriInfo;
    private final ApplicationManager applicationManager;
    private final DirectoryManager directoryManager;
    private final TrustedProxyManager trustedProxyManager;

    public ApplicationResourcesForTests(ApplicationManager applicationManager, DirectoryManager directoryManager, TrustedProxyManager trustedProxyManager) {
        this.applicationManager = applicationManager;
        this.directoryManager = directoryManager;
        this.trustedProxyManager = trustedProxyManager;
    }

    @POST
    public Response createApplication(ApplicationEntity applicationEntityWithoutAddresses) throws InvalidCredentialException, DirectoryNotFoundException, UnknownHostException {
        ApplicationEntity applicationEntity = this.setRemoteAddresses(applicationEntityWithoutAddresses);
        Application applicationWithNoDirectoryMappings = ApplicationEntityTranslator.toApplicationWithNoDirectoryMappings(applicationEntity);
        Application addedApplication = this.applicationManager.add(applicationWithNoDirectoryMappings);
        if (applicationEntity.getDirectoryMappings() != null && !applicationEntity.getDirectoryMappings().isEmpty()) {
            List<DirectoryMapping> directoryMappings = ApplicationEntityTranslator.toDirectoryMappings(applicationEntity.getDirectoryMappings(), addedApplication, this.directoryManager);
            ImmutableApplication newApplication = ImmutableApplication.builder((Application)addedApplication).setDirectoryMappings(directoryMappings).build();
            try {
                this.applicationManager.update((Application)newApplication);
            }
            catch (ApplicationNotFoundException | ApplicationManagerException e) {
                throw new RuntimeException(e);
            }
        }
        Link link = ApplicationLinkUriHelper.buildApplicationLink(this.uriInfo.getBaseUri(), addedApplication.getId());
        return Response.created((URI)link.getHref()).build();
    }

    private ApplicationEntity setRemoteAddresses(ApplicationEntity applicationEntity) throws UnknownHostException {
        Set<String> addresses = this.getRequestAddresses(this.request);
        if (!addresses.isEmpty()) {
            if (applicationEntity.getRemoteAddresses() == null) {
                applicationEntity.setRemoteAddresses(new RemoteAddressEntitySet(Sets.newHashSet(), null));
            }
            for (String address : addresses) {
                applicationEntity.getRemoteAddresses().addRemoteAddress(new RemoteAddressEntity(address, null));
            }
        }
        return applicationEntity;
    }

    private Set<String> getRequestAddresses(HttpServletRequest request) throws UnknownHostException {
        HashSet addresses = Sets.newHashSet();
        addresses.add(request.getRemoteAddr());
        InetAddress clientAddress = XForwardedForUtil.getTrustedAddress((TrustedProxyManager)this.trustedProxyManager, (HttpServletRequest)request);
        addresses.add(clientAddress.getHostAddress());
        for (InetAddress address : InetAddress.getAllByName(clientAddress.getHostName())) {
            addresses.add(address.getHostAddress());
        }
        return addresses;
    }

    @DELETE
    @Path(value="{applicationId}")
    public Response removeApplication(@PathParam(value="applicationId") long applicationId) throws ApplicationManagerException, ApplicationNotFoundException {
        Application application = this.applicationManager.findById(applicationId);
        this.applicationManager.remove(application);
        return Response.noContent().build();
    }
}

