/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.common.Error;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BulkAppAccessOperationResult;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.InvitationsRequestEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ListViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.QuickAddRequestEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntityList;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UserFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UsersProductAccessList;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupMembershipChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MembershipChangeCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.util.RestResources;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.EmailFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.GroupFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.crowd.plugin.usermanagement.util.UserInvite;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class UsersResource
extends BaseResource {
    private final UserController userController;
    private final UserAndGroupService userAndGroupService;
    private final I18nResolver i18nResolver;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final ProductService productService;
    private final DarkFeatureManager darkFeatureManager;
    private final UserProvisioningService userProvisioningService;

    public UsersResource(UserController userController, UserAndGroupService userAndGroupService, I18nResolver i18nResolver, UserAndGroupCheckService userAndGroupCheckService, ProductService productService, DarkFeatureManager darkFeatureManager, UserProvisioningService userProvisioningService) {
        this.darkFeatureManager = darkFeatureManager;
        this.userController = (UserController)Preconditions.checkNotNull((Object)userController);
        this.userAndGroupService = userAndGroupService;
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.productService = productService;
        this.userProvisioningService = userProvisioningService;
    }

    @GET
    public Response getUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException {
        RestResources.checkParam("username", userName);
        UserEntity user = this.userController.getUser(userName, this.getBaseUri());
        return ResponseFactory.ok(user).build();
    }

    @GET
    @Path(value="hasUsersOfType")
    public Response hasUserType(@QueryParam(value="userFilter") String userType) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Iterable<UserEntity> users = this.userController.findUsersByName("", 0, 1, this.getBaseUri(), Collections.singletonList(userType), null, Collections.emptyList());
        return ResponseFactory.ok(!Iterables.isEmpty(users)).build();
    }

    @GET
    @Path(value="search")
    public Response searchUsers(@QueryParam(value="filter") String filter, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults, @QueryParam(value="userFilters") List<String> userFilters, @QueryParam(value="activeFilter") List<String> activeFilter, @QueryParam(value="n") List<String> newUserNamesToPrepend) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Iterable<UserEntity> userEntities = this.userController.findUsersByName(filter, startIndex, maxResults, this.getBaseUri(), userFilters, this.convertActiveFilter(activeFilter), newUserNamesToPrepend);
        Iterable users = Iterables.transform(userEntities, ListViewUser.fromUserEntityPredicate(this.userAndGroupCheckService, this.i18nResolver));
        return ResponseFactory.ok(users).build();
    }

    private List<Boolean> convertActiveFilter(List<String> activeFilter) {
        if (activeFilter.isEmpty()) {
            return ImmutableList.of();
        }
        return Lists.transform(activeFilter, (Function)new Function<String, Boolean>(){

            public Boolean apply(String filter) {
                switch (filter.toLowerCase()) {
                    case "active": {
                        return true;
                    }
                    case "inactive": {
                        return false;
                    }
                }
                throw new IllegalArgumentException("Invalid filter type in activeFilter. Filter should be active or inactive");
            }
        });
    }

    @POST
    public Response addUser(UserFormEntity userEntity) throws InvalidCredentialException, DirectoryPermissionException, DirectoryNotFoundException, InvalidUserException, OperationFailedException, InvalidEmailAddressException, UserNotFoundException, ReadOnlyGroupException, GroupNotFoundException, IOException, MembershipAlreadyExistsException, ResponseException, LicenseExceededException, ProductAccessErrorException, MailServerConfigurationException, UserAlreadyExistsException, EmailAlreadyExistsException, NoDefaultGroupException, MembershipChangeCausingLicenseException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkArgument((userEntity != null ? 1 : 0) != 0);
        this.checkUserDetailsFields(userEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        UserEntity createdUser = this.userController.addUser(userEntity, this.getBaseUri(), this.getBaseUrl());
        URI location = LinkUriHelper.buildUserUri(this.getBaseUri(), createdUser.getName());
        return ResponseFactory.created(location).entity((Object)createdUser).build();
    }

    @POST
    @Path(value="invite")
    public Response inviteUser(InvitationsRequestEntity request) throws MailSendException, MailServerConfigurationException, AddressException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, ObjectAlreadyExistsException, InvalidCredentialException, InvalidUserException, EmailAlreadyExistsException, LicenseExceededException, DirectoryPermissionException, ReadOnlyGroupException, MembershipChangeCausingLicenseException, GroupNotFoundException, NoDefaultGroupException {
        return ResponseFactory.ok(this.userController.inviteUser(request.buildInvite(), Option.some(ProductId.getProductIds(request.getApplications())), request.getExpiryDays(), Option.some(request.getText()), this.getBaseUrl())).build();
    }

    @POST
    @Path(value="quickAdd")
    public Response quickAdd(QuickAddRequestEntity request) throws MailSendException, MailServerConfigurationException, AddressException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, ObjectAlreadyExistsException, InvalidCredentialException, InvalidUserException, EmailAlreadyExistsException, LicenseExceededException, DirectoryPermissionException, ReadOnlyGroupException, MembershipChangeCausingLicenseException, GroupNotFoundException, NoDefaultGroupException {
        List<UserInvite> invites = request.buildInvite();
        List<Error> errors = this.checkQuickAdd(invites);
        ImmutableSet inviteSet = ImmutableSet.copyOf(this.compressQuickAddField(invites));
        if (inviteSet.isEmpty()) {
            return UsersResource.buildErrors((List<Error>)ImmutableList.of((Object)new Error("emails", 0, this.i18nResolver.getText("usermanagement.validation.email.missing")), (Object)new Error("names", 0, this.i18nResolver.getText("usermanagement.validation.displayname.missing"))));
        }
        if (errors.size() > 0) {
            return UsersResource.buildErrors(errors);
        }
        return ResponseFactory.ok(this.userController.inviteUser((Set<UserInvite>)inviteSet, Option.none(), request.getExpiryDays(), Option.none(), this.getBaseUrl())).build();
    }

    @POST
    @Path(value="access")
    public Response grantApplicationAccess(UsersProductAccessList usersProductAccessList) throws DirectoryNotFoundException, OperationFailedException, ProductAccessChangeNotAllowedException, NoDefaultGroupException, UserNotFoundException, MembershipChangeCausingLicenseException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, LicenseExceededException {
        BulkAppAccessOperationResult result;
        String productToAddFromLookup = usersProductAccessList.getGroup();
        List<String> productIdStrings = usersProductAccessList.getProductIds();
        List<Product> allProducts = this.productService.fetchProducts();
        Set<Product> requiredProducts = ProductUtils.findProducts(allProducts, ProductId.getProductIds(productIdStrings));
        if (productToAddFromLookup == null) {
            List<String> usernames = usersProductAccessList.getUsernames();
            result = this.userController.grantProductAccess(allProducts, usernames, requiredProducts, false);
        } else {
            Set<Product> filteredList = this.filterRedundantProducts(requiredProducts, productToAddFromLookup);
            result = this.userController.grantProductAccess(allProducts, productToAddFromLookup, filteredList);
        }
        return ResponseFactory.ok(result).build();
    }

    private Set<Product> filterRedundantProducts(Set<Product> productsToAddTo, String productToAddFromString) {
        if ("all".equals(productToAddFromString)) {
            return productsToAddTo;
        }
        final ProductId productToAddFrom = new ProductId(productToAddFromString);
        final String addFromPlatformProductName = this.findPlatformProductFromProductName(productToAddFrom);
        return ImmutableSet.copyOf((Iterable)Iterables.filter(productsToAddTo, (Predicate)new Predicate<Product>(){

            public boolean apply(Product product) {
                return !productToAddFrom.equals(product.getProductId()) && !addFromPlatformProductName.equals(product.getProductName());
            }
        }));
    }

    private String findPlatformProductFromProductName(ProductId productId) {
        Either<ProductAccessError, ProductConfig> productConfig;
        String addFromPlatformProductName = "noPlatformProduct";
        Option<Product> groupsProductOption = this.productService.getProduct(productId);
        if (!groupsProductOption.isEmpty() && (productConfig = ((Product)groupsProductOption.get()).getConfig()).isRight()) {
            addFromPlatformProductName = ((ProductConfig)productConfig.right().get()).getPlatformProductName();
        }
        return addFromPlatformProductName;
    }

    @DELETE
    @Path(value="access")
    public Response revokeApplicationAccess(@QueryParam(value="username") String username, @QueryParam(value="productId") String productId) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Either<ConflictingConfiguration, UserEntity> result = this.userController.revokeProductAccess(username, this.getBaseUri(), new ProductId(productId));
        if (result.isRight()) {
            return ResponseFactory.noContent().build();
        }
        return this.buildResponseForConflictingConfiguration((ConflictingConfiguration)result.left().get());
    }

    @PUT
    public Response updateUser(@QueryParam(value="username") String userName, UserFormEntity userFormEntity) throws UserNotFoundException, InvalidUserException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserModificationNotAllowedException, EmailAlreadyExistsException, UserAlreadyExistsException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((userFormEntity != null ? 1 : 0) != 0);
        this.checkUserDetailsFields(userFormEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        if (!StringUtils.equals(userName, userFormEntity.getName())) {
            this.userController.renameUser(userName, userFormEntity);
        }
        UserEntity userEntity = this.userController.updateUser(userFormEntity, this.getBaseUri(), false);
        return ResponseFactory.status(Response.Status.OK).entity((Object)userEntity).build();
    }

    private Response buildResponseForConflictingConfiguration(ConflictingConfiguration malConfig) {
        return UsersResource.buildErrors(this.i18nResolver.getText("usermanagement.apps.change.fail.on.conflict.config"));
    }

    @DELETE
    public Response deleteUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserCannotBeDeletedException {
        RestResources.checkParam("username", userName);
        this.userAndGroupService.deleteUser(userName);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="password")
    public Response updateUserPassword(@QueryParam(value="username") String userName, PasswordEntity passwordEntity) throws InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException, UserModificationNotAllowedException {
        RestResources.checkParam("username", userName);
        HashMap errors = Maps.newHashMap();
        this.checkPassword(passwordEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        this.userController.updateUserPassword(userName, passwordEntity.getValue());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="group/direct")
    public Response getDirectGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @QueryParam(value="n") List<String> newGroupNamesToPrepend, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException, DirectoryNotFoundException, OperationFailedException {
        RestResources.checkParam("username", userName);
        if (StringUtils.isEmpty(groupName)) {
            RestGroupEntityList directGroups = this.userController.getDirectGroups(userName, maxResults, startIndex, newGroupNamesToPrepend, this.getBaseUri());
            return ResponseFactory.ok(directGroups).build();
        }
        RestGroupEntity directGroup = this.userController.getDirectGroup(userName, groupName, this.getBaseUri());
        return ResponseFactory.ok(directGroup).build();
    }

    @POST
    @Path(value="group/direct")
    public Response addUserToGroup(@QueryParam(value="username") String userName, GroupEntityList groupList) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException, ReadOnlyGroupException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, SysadminGroupModificationNotAllowedException, ProductAccessErrorException, MembershipChangeCausingLicenseException, UserModificationNotAllowedException, GroupMembershipChangeNotAllowedException, LicenseExceededException {
        RestResources.checkParam("username", userName);
        List<Product> allProducts = this.productService.fetchProducts();
        Iterable groupNames = Iterables.transform((Iterable)groupList, GroupFunctions.groupEntityNameGetter());
        this.userProvisioningService.addUsersToGroups(allProducts, (Set<String>)ImmutableSet.of((Object)userName), (Set<String>)ImmutableSet.copyOf((Iterable)groupNames));
        return ResponseFactory.ok(groupList).build();
    }

    @DELETE
    @Path(value="group/direct")
    public Response removeUserFromGroup(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName) throws GroupNotFoundException, MembershipNotFoundException, UserNotFoundException, ApplicationPermissionException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, ReadOnlyGroupException, SysadminGroupModificationNotAllowedException, UserModificationNotAllowedException {
        RestResources.checkParam("username", userName);
        this.userAndGroupService.removeUserFromGroup(userName, groupName);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="AID")
    public Response dissociateAIDFromCrowdUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException {
        RestResources.checkParam("username", userName);
        this.userController.removeAIDFromUser(userName);
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="deactivate")
    public Response deactivateUser(@QueryParam(value="username") String username) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers("um.disable.user.off")) {
            return ResponseFactory.status(Response.Status.NOT_FOUND).build();
        }
        this.userController.updateUserActive(username, this.getBaseUri(), false);
        return ResponseFactory.ok().build();
    }

    @POST
    @Path(value="activate")
    public Response activateUser(@QueryParam(value="username") String username) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers("um.disable.user.off")) {
            return ResponseFactory.status(Response.Status.NOT_FOUND).build();
        }
        this.userController.updateUserActive(username, this.getBaseUri(), true);
        return ResponseFactory.ok().build();
    }

    private void checkUserDetailsFields(UserEntity userEntity, Map<String, String> errors) {
        this.checkUsername(userEntity, errors);
        this.checkDisplayName(userEntity, errors);
        this.checkEmail(userEntity, errors);
    }

    private void checkUsername(UserEntity userEntity, Map<String, String> errors) {
        String username = userEntity.getName();
        UsersResource.checkArgument(errors, StringUtils.isNotBlank(username), "name", this.i18nResolver.getText("usermanagement.validation.username.missing"));
        UsersResource.checkArgument(errors, StringUtils.length(username) <= 255, "name", this.i18nResolver.getText("usermanagement.validation.username.exceed.max.length", new Serializable[]{Integer.valueOf(255)}));
    }

    protected Iterable<UserInvite> compressQuickAddField(Iterable<UserInvite> invites) {
        Iterable compressedInvites = Iterables.filter(invites, (Predicate)new Predicate<UserInvite>(){

            public boolean apply(@Nullable UserInvite userInvite) {
                String currentEmail = userInvite.email();
                String currentName = userInvite.displayName().getOrNull();
                return StringUtils.isNotBlank(currentEmail) || StringUtils.isNotBlank(currentName);
            }
        });
        return compressedInvites;
    }

    protected List<Error> checkQuickAdd(Iterable<UserInvite> invites) {
        ImmutableList.Builder errors = ImmutableList.builder();
        int index = 0;
        for (UserInvite invite : invites) {
            String currentEmail = invite.email();
            String currentName = invite.displayName().getOrNull();
            if (StringUtils.isNotBlank(currentEmail) && StringUtils.isBlank(currentName)) {
                errors.add((Object)new Error("names", index, this.i18nResolver.getText("usermanagement.validation.displayname.missing")));
            }
            if (StringUtils.isBlank(currentEmail) && StringUtils.isNotBlank(currentName)) {
                errors.add((Object)new Error("emails", index, this.i18nResolver.getText("usermanagement.validation.email.missing")));
            }
            if (StringUtils.isNotBlank(currentEmail) && !EmailFunctions.isValidEmailAddress(currentEmail)) {
                errors.add((Object)new Error("emails", index, this.i18nResolver.getText("usermanagement.validation.email.invalid")));
            }
            ++index;
        }
        return errors.build();
    }

    private void checkDisplayName(UserEntity userEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getDisplayName()), "display-name", this.i18nResolver.getText("usermanagement.validation.displayname.missing"));
    }

    private void checkEmail(UserEntity userEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, EmailFunctions.VALID_EMAIL_ADDRESS.apply((Object)userEntity.getEmail()), "email", this.i18nResolver.getText("usermanagement.validation.email.invalid"));
    }

    private void checkPassword(PasswordEntity passwordEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, passwordEntity != null && StringUtils.isNotBlank(passwordEntity.getValue()), "value", this.i18nResolver.getText("usermanagement.users.password.change.empty"));
    }
}

