/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.jersey.NewCookie;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UsernameEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.SendEmailService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.util.AllowAllToAuthApplication;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.mail.internet.AddressException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

@Path(value="impersonate")
@FeatureGuard(value="um.impersonation")
@Consumes(value={"application/json"})
public class ImpersonatingResource
extends BaseResource {
    private final String applicationName;
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private final ClientProperties clientProperties;
    private final PropertyManager propertyManager;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final UserManager userManager;
    private final SendEmailService sendEmailService;
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;
    private static final Logger log = LoggerFactory.getLogger(ImpersonatingResource.class);

    public ImpersonatingResource(TokenAuthenticationManager tokenAuthenticationManager, ClientProperties clientProperties, PropertyManager propertyManager, UserAndGroupCheckService userAndGroupCheckService, UserManager userManager, AllowAllToAuthApplication allowAllToAuthApplication, SendEmailService sendEmailService, DirectoryManager directoryManager, DirectoryLocator directoryLocator) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
        this.clientProperties = clientProperties;
        this.propertyManager = propertyManager;
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.userManager = userManager;
        this.applicationName = allowAllToAuthApplication.getApplicationName();
        this.sendEmailService = sendEmailService;
        this.directoryManager = directoryManager;
        this.directoryLocator = directoryLocator;
    }

    @ResourceFilters(value={AdminOnlyResourceFilter.class})
    @POST
    public Response impersonate(UsernameEntity usernameEntity, @Context HttpServletRequest request, @Context HttpServletResponse response) throws InactiveAccountException, ApplicationNotFoundException, ApplicationAccessDeniedException, OperationFailedException, InvalidAuthenticationException, PropertyManagerException, DirectoryNotFoundException, UserNotFoundException {
        if (usernameEntity == null || StringUtils.isBlank(usernameEntity.getUsername())) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).build();
        }
        if (this.userAndGroupCheckService.canCurrentUserModifyUserData(usernameEntity.getUsername()).isDefined()) {
            return ResponseFactory.status(Response.Status.FORBIDDEN).build();
        }
        if (this.userManager.isAdmin(usernameEntity.getUsername())) {
            return ResponseFactory.status(Response.Status.FORBIDDEN).build();
        }
        String cookieTokenKey = this.clientProperties.getCookieTokenKey();
        String oldCookieTokenKey = cookieTokenKey + ".old";
        String oldToken = ImpersonatingResource.getCrowdToken(request, oldCookieTokenKey);
        if (oldToken != null) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).build();
        }
        String token = ImpersonatingResource.getCrowdToken(request, cookieTokenKey);
        String newToken = this.authenticateUserWithoutValidatingPassword(request, usernameEntity.getUsername(), this.clientProperties).getRandomHash();
        boolean secure = this.propertyManager.isSecureCookie();
        UserProfile impersonatingUser = this.userManager.getRemoteUser();
        log.info("User '{}' is impersonating user '{}'", (Object)impersonatingUser.getUsername(), (Object)usernameEntity.getUsername());
        long directoryId = this.directoryLocator.getDirectoryId();
        UserWithAttributes impersonatedUser = this.directoryManager.findUserWithAttributesByName(directoryId, usernameEntity.getUsername());
        this.sendImpersonationWarningEmail(impersonatedUser, impersonatingUser, directoryId);
        return ResponseFactory.ok().cookie(new javax.ws.rs.core.NewCookie[]{this.buildHttpOnlyCookie(cookieTokenKey, newToken, -1, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildHttpOnlyCookie(oldCookieTokenKey, token, -1, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildNonHttpOnlyCookie("um.user.impersonated.username", impersonatedUser.getName(), -1, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildNonHttpOnlyCookie("um.user.impersonated.displayname", impersonatedUser.getDisplayName(), -1, secure)}).build();
    }

    private Token authenticateUserWithoutValidatingPassword(HttpServletRequest request, String username, ClientProperties clientProperties) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ApplicationNotFoundException {
        try {
            return this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(ImpersonatingResource.getUserAuthenticationContext(request, username, this.applicationName));
        }
        catch (ApplicationNotFoundException e) {
            return this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(ImpersonatingResource.getUserAuthenticationContext(request, username, clientProperties.getApplicationName()));
        }
    }

    @AnonymousAllowed
    @POST
    @Path(value="release")
    public Response release(@Context HttpServletRequest request, @Context HttpServletResponse response) throws PropertyManagerException, UnknownHostException {
        String cookieTokenKey = this.clientProperties.getCookieTokenKey();
        String oldCookieTokenKey = cookieTokenKey + ".old";
        String oldToken = ImpersonatingResource.getCrowdToken(request, oldCookieTokenKey);
        if (oldToken != null) {
            boolean secure = this.propertyManager.isSecureCookie();
            UserProfile user = this.userManager.getRemoteUser();
            log.info("User '{}' is explicitly dropping impersonation access", (Object)user.getUsername());
            return ResponseFactory.ok().cookie(new javax.ws.rs.core.NewCookie[]{this.buildHttpOnlyCookie(cookieTokenKey, oldToken, -1, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildHttpOnlyCookie(oldCookieTokenKey, null, 0, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildNonHttpOnlyCookie("um.user.impersonated.username", null, 0, secure)}).cookie(new javax.ws.rs.core.NewCookie[]{this.buildNonHttpOnlyCookie("um.user.impersonated.displayname", null, 0, secure)}).build();
        }
        return ResponseFactory.ok().build();
    }

    private NewCookie buildHttpOnlyCookie(String name, String value, int maxAge, boolean secure) {
        return this.buildCookie(name, value, maxAge, secure, true);
    }

    private NewCookie buildNonHttpOnlyCookie(String name, String value, int maxAge, boolean secure) {
        return this.buildCookie(name, value, maxAge, secure, false);
    }

    private NewCookie buildCookie(String name, String value, int maxAge, boolean secure, boolean httpOnly) {
        return new NewCookie(name, this.encodeCookieValue(value), "/", this.getCookieDomain(), null, maxAge, secure, httpOnly);
    }

    private String encodeCookieValue(String value) {
        try {
            return UriUtils.encodeQueryParam((String)value, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Encoding the cookie value failed, which should not be possible!", (Throwable)e);
            return null;
        }
    }

    private String getCookieDomain() {
        String domain = this.getBaseUri().getHost();
        return "localhost".equals(domain) ? domain : "." + domain;
    }

    private static String getCrowdToken(HttpServletRequest request, final String tokenName) {
        Cookie cookie = (Cookie)Iterables.find(Arrays.asList(request.getCookies()), (Predicate)new Predicate<Cookie>(){

            public boolean apply(Cookie cookie) {
                return tokenName.equals(cookie.getName());
            }
        }, null);
        return cookie != null ? cookie.getValue() : null;
    }

    private static UserAuthenticationContext getUserAuthenticationContext(HttpServletRequest request, String username, String application) {
        return new UserAuthenticationContext(username, null, ImpersonatingResource.getValidationFactors(request), application);
    }

    private static ValidationFactor[] getValidationFactors(HttpServletRequest request) {
        return CrowdHttpValidationFactorExtractorImpl.getInstance().getValidationFactors(request).toArray(new ValidationFactor[0]);
    }

    @VisibleForTesting
    void sendImpersonationWarningEmail(UserWithAttributes impersonatedUser, UserProfile impersonatingUser, long directoryId) {
        if (impersonatedUser.getValue("lastAuthenticated") != null) {
            try {
                this.sendEmailService.sendBeingImpersonatedEmail((User)impersonatedUser, this.directoryManager.findUserByName(directoryId, impersonatingUser.getUsername()));
            }
            catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException | MailSendException | MailServerConfigurationException | AddressException e) {
                log.error("Unable to send an email to user '" + impersonatedUser.getName() + "' to alert them that '" + impersonatingUser.getUsername() + "' is impersonating them.", e);
            }
        }
    }
}

