/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MembershipChangeCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.util.RestResources;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="google-apps/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class GoogleAppsUserResource
extends BaseResource {
    private final UserController userController;
    private final UserManager userManager;

    public GoogleAppsUserResource(UserController userController, UserManager userManager) {
        this.userManager = userManager;
        this.userController = (UserController)Preconditions.checkNotNull((Object)userController);
    }

    @GET
    public Response getUser(@QueryParam(value="username") String userName) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException {
        RestResources.checkParam("username", userName);
        UserEntity user = this.userController.getUser(userName, this.getBaseUri());
        return ResponseFactory.ok(user).build();
    }

    @GET
    @Path(value="admin")
    public Response isAdmin(@QueryParam(value="username") String username) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        RestResources.checkParam("username", username);
        UserEntity user = this.userController.getUser(username, this.getBaseUri());
        if (user == null) {
            return ResponseFactory.status(Response.Status.NOT_FOUND).build();
        }
        return ResponseFactory.ok(new IsAdminResponse().setUsername(username).setIsAdmin(this.userManager.isAdmin(username))).build();
    }

    @POST
    public Response createUser(UserEntity userEntity) throws DirectoryPermissionException, OperationFailedException, DirectoryNotFoundException, InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, EmailAlreadyExistsException, UserNotFoundException, GroupNotFoundException, MembershipChangeCausingLicenseException, ReadOnlyGroupException, NoDefaultGroupException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkNotNull((Object)userEntity);
        GoogleAppsUserResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getDisplayName()), "display-name", "A name must be supplied");
        GoogleAppsUserResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getEmail()), "email", "An email address must be supplied");
        if (GoogleAppsUserResource.hasErrors(errors)) {
            return GoogleAppsUserResource.buildErrors(errors);
        }
        try {
            UserEntity createdUser = this.userController.addUserWithDefaultProductAccess(userEntity, this.getBaseUri(), true);
            URI location = LinkUriHelper.buildUserUri(this.getBaseUri(), createdUser.getName());
            return ResponseFactory.created(location).entity((Object)createdUser).build();
        }
        catch (LicenseExceededException lee) {
            return ResponseFactory.status(Response.Status.CONFLICT).entity((Object)"License exceeded").build();
        }
    }

    @POST
    @Path(value="/grant-default-app-access")
    public Response grantUserDefaultApplicationAccess(@QueryParam(value="username") String userName) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, NoDefaultGroupException, GroupNotFoundException, MembershipChangeCausingLicenseException, ReadOnlyGroupException, DirectoryPermissionException {
        Preconditions.checkNotNull((Object)userName);
        try {
            this.userController.grantDefaultProductAccess(userName);
            return ResponseFactory.noContent().build();
        }
        catch (LicenseExceededException lee) {
            return ResponseFactory.status(Response.Status.CONFLICT).entity((Object)"License exceeded").build();
        }
    }

    @PUT
    public Response updateUser(@QueryParam(value="username") String userName, UserEntity userEntity) throws UserNotFoundException, InvalidUserException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, EmailAlreadyExistsException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)userEntity);
        GoogleAppsUserResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getDisplayName()), "display-name", "A name must be supplied");
        GoogleAppsUserResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getEmail()), "email", "An email address must be supplied");
        if (GoogleAppsUserResource.hasErrors(errors)) {
            return GoogleAppsUserResource.buildErrors(errors);
        }
        if (!StringUtils.equalsIgnoreCase(userName, userEntity.getName())) {
            throw new IllegalArgumentException("The names of the resource location <" + this.getPath() + "> and object <" + userEntity.getName() + "> are not equal");
        }
        UserEntity updatedUserEntity = this.userController.updateUser(userEntity, this.getBaseUri(), true);
        return ResponseFactory.ok(updatedUserEntity).build();
    }

    public static class IsAdminResponse {
        @JsonProperty
        private String username;
        @JsonProperty
        private Boolean isAdmin;

        public IsAdminResponse setUsername(String username) {
            this.username = username;
            return this;
        }

        public IsAdminResponse setIsAdmin(boolean isSiteAdmin) {
            this.isAdmin = isSiteAdmin;
            return this;
        }
    }
}

