/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.AdminLockService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="lock")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class AdminLockResource
extends BaseResource {
    private final AdminLockService adminLockService;

    public AdminLockResource(AdminLockService adminLockService) {
        this.adminLockService = adminLockService;
    }

    @GET
    public Response getLockStatus() {
        return ResponseFactory.ok(this.adminLockService.getLockedStatus()).build();
    }

    @PUT
    public Response lock(@QueryParam(value="reason") String reason) {
        this.adminLockService.lockAdmin(reason);
        return ResponseFactory.ok(this.adminLockService.getLockedStatus()).build();
    }

    @DELETE
    public Response unlock() {
        this.adminLockService.unlockAdmin();
        return ResponseFactory.ok(this.adminLockService.getLockedStatus()).build();
    }
}

