/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class NoDefaultGroupExceptionMapper
implements ExceptionMapper<NoDefaultGroupException> {
    private final I18nResolver i18nResolver;
    private final DarkFeatureManager darkFeatureManager;

    public NoDefaultGroupExceptionMapper(I18nResolver i18nResolver, DarkFeatureManager darkFeatureManager) {
        this.i18nResolver = i18nResolver;
        this.darkFeatureManager = darkFeatureManager;
    }

    public Response toResponse(NoDefaultGroupException exception) {
        String errorMessage = this.darkFeatureManager.isFeatureEnabledForAllUsers("um.renaissance") ? this.i18nResolver.getText("usermanagement.apps.no.defaults.exception", new Serializable[]{exception.getProduct().getProductName()}) : this.i18nResolver.getText("usermanagement.apps.no.defaults.exception.no.renaissance", new Serializable[]{exception.getProduct().getProductName()});
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(errorMessage)).build();
    }
}

