/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MembershipChangeCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class MembershipChangeCausingLicenseExceptionMapper
implements ExceptionMapper<MembershipChangeCausingLicenseException> {
    private final I18nResolver i18nResolver;

    public MembershipChangeCausingLicenseExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(MembershipChangeCausingLicenseException e) {
        Map<Product, MembershipChangeCausingLicenseExceeded> errors = e.getInfo();
        StringBuilder builder = new StringBuilder();
        boolean needSeparator = false;
        for (Product product : errors.keySet()) {
            if (needSeparator) {
                builder.append(" ");
            }
            needSeparator = true;
            LicenseExceeded licenseExceeded = errors.get(product).getLicenseExceeded();
            if (licenseExceeded.getAvailable() >= 0) {
                builder.append(this.i18nResolver.getText("usermanagement.apps.license.exceeded.error", new Serializable[]{product.getProductName(), Integer.valueOf(licenseExceeded.getNeeded()), Integer.valueOf(licenseExceeded.getAvailable())}));
                continue;
            }
            builder.append(this.i18nResolver.getText("usermanagement.apps.license.exceeded.error.negative.seats", new Serializable[]{product.getProductName(), Integer.valueOf(licenseExceeded.getNeeded()), Integer.valueOf(-1 * licenseExceeded.getAvailable())}));
        }
        return ResponseFactory.status(Response.Status.CONFLICT).entity((Object)ErrorEntity.withGenericError(builder.toString())).build();
    }
}

